/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.6.12", status=API.Status.MAINTAINED)
public final class FactoryMethodArbitraryIntrospector
implements ArbitraryIntrospector {
    private final FactoryMethodWithParameterNames factoryMethodWithParameterNames;

    public FactoryMethodArbitraryIntrospector(FactoryMethodWithParameterNames factoryMethodWithParameterNames) {
        this.factoryMethodWithParameterNames = factoryMethodWithParameterNames;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (Modifier.isAbstract(type.getModifiers())) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.objectBuilder().properties(context.getCombinableArbitrariesByArbitraryProperty()).build(FactoryMethodArbitraryIntrospector.combine(this.factoryMethodWithParameterNames.getFactoryMethod(), this.factoryMethodWithParameterNames.getParameterNames())));
    }

    private static Function<Map<ArbitraryProperty, Object>, Object> combine(Method factoryMethod, List<String> parameterNames) {
        int parameterSize = parameterNames.size();
        return propertyValuesByArbitraryProperty -> {
            HashMap valuesByPropertyName = new HashMap();
            propertyValuesByArbitraryProperty.forEach((key, value) -> valuesByPropertyName.put(key.getObjectProperty().getProperty().getName(), value));
            ArrayList list = new ArrayList(parameterSize);
            for (String parameterName : parameterNames) {
                Object combined = valuesByPropertyName.getOrDefault(parameterName, null);
                list.add(combined);
            }
            try {
                return factoryMethod.invoke(null, list.toArray());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static class FactoryMethodWithParameterNames {
        private final Method factoryMethod;
        private final List<String> parameterNames;

        public FactoryMethodWithParameterNames(Method factoryMethod, List<String> parameterNames) {
            this.factoryMethod = factoryMethod;
            this.parameterNames = parameterNames;
        }

        public Method getFactoryMethod() {
            return this.factoryMethod;
        }

        public List<String> getParameterNames() {
            return this.parameterNames;
        }
    }
}

