/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.ConstructorArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(since="1.0.26", status=API.Status.EXPERIMENTAL)
public final class PriorityConstructorArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final PriorityConstructorArbitraryIntrospector INSTANCE = new PriorityConstructorArbitraryIntrospector();
    private static final Map<Property, ConstructorArbitraryIntrospector> CONSTRUCTOR_INTROSPECTORS_BY_PROPERTY = new ConcurrentLruCache<Property, ConstructorArbitraryIntrospector>(256);
    private final Predicate<Constructor<?>> constructorFilter;
    private final Comparator<Constructor<?>> sortingCriteria;
    private final Function<Constructor<?>, List<String>> parameterNamesResolver;

    public PriorityConstructorArbitraryIntrospector() {
        this(constructor -> !Modifier.isPrivate(constructor.getModifiers()), Comparator.comparing(Constructor::getParameterCount), constructor -> Collections.emptyList());
    }

    public PriorityConstructorArbitraryIntrospector withConstructorFilter(Predicate<Constructor<?>> constructorFilter) {
        return new PriorityConstructorArbitraryIntrospector(constructorFilter, this.sortingCriteria, this.parameterNamesResolver);
    }

    public PriorityConstructorArbitraryIntrospector withSortingCriteria(Comparator<Constructor<?>> sortingCriteria) {
        return new PriorityConstructorArbitraryIntrospector(this.constructorFilter, sortingCriteria, this.parameterNamesResolver);
    }

    public PriorityConstructorArbitraryIntrospector withParameterNamesResolver(Function<Constructor<?>, List<String>> parameterNamesResolver) {
        return new PriorityConstructorArbitraryIntrospector(this.constructorFilter, this.sortingCriteria, parameterNamesResolver);
    }

    private PriorityConstructorArbitraryIntrospector(Predicate<Constructor<?>> constructorFilter, Comparator<Constructor<?>> sortingCriteria, Function<Constructor<?>, List<String>> parameterNamesResolver) {
        this.constructorFilter = constructorFilter;
        this.sortingCriteria = sortingCriteria;
        this.parameterNamesResolver = parameterNamesResolver;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        return this.getConstructorArbitraryIntrospector(context.getResolvedProperty()).introspect(context);
    }

    @Override
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        return this.getConstructorArbitraryIntrospector(property).getRequiredPropertyGenerator(property);
    }

    private ConstructorArbitraryIntrospector getConstructorArbitraryIntrospector(Property property) {
        Class<?> actualType = Types.getActualType(property.getType());
        return CONSTRUCTOR_INTROSPECTORS_BY_PROPERTY.computeIfAbsent(property, p -> {
            Constructor<?> constructor = TypeCache.getDeclaredConstructors(actualType).stream().filter(this.constructorFilter).min(this.sortingCriteria).orElseThrow(() -> new IllegalArgumentException("No matching constructor given type: " + actualType.getTypeName()));
            List<String> parameterNames = this.parameterNamesResolver.apply(constructor);
            if (!parameterNames.isEmpty() && parameterNames.size() != constructor.getParameterCount()) {
                throw new IllegalArgumentException("PriorityConstructorArbitraryIntrospector fails to resolve the parameter names with the constructor of " + actualType.getTypeName() + " Please check your parameterNamesResolver.");
            }
            return new ConstructorArbitraryIntrospector(new ConstructorArbitraryIntrospector.ConstructorWithParameterNames(constructor, parameterNames));
        });
    }
}

