/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.option;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfoGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArrayContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.DefaultObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.DefaultSingleContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.EntryContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.FunctionalInterfaceContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.MapContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.MapEntryElementContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.NoArgumentInterfaceJavaMethodPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.OptionalContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.SetContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.StreamContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorProcessor;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.ConstantIntrospector;
import com.navercorp.fixturemonkey.api.introspector.NullArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.DoubleGenericTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.ExactPropertyMatcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.matcher.Matchers;
import com.navercorp.fixturemonkey.api.matcher.SingleGenericTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.TreeMatcherOperator;
import com.navercorp.fixturemonkey.api.option.BuilderContextInitializer;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptionsBuilder;
import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.CompositeCandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.ConcreteTypeCandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public final class FixtureMonkeyOptions {
    private static final List<String> DEFAULT_JAVA_PACKAGES;
    public static final List<MatcherOperator<ContainerPropertyGenerator>> DEFAULT_CONTAINER_PROPERTY_GENERATORS;
    public static final List<MatcherOperator<ArbitraryIntrospector>> DEFAULT_ARBITRARY_INTROSPECTORS;
    public static final ObjectPropertyGenerator DEFAULT_OBJECT_PROPERTY_GENERATOR;
    public static final PropertyNameResolver DEFAULT_PROPERTY_NAME_RESOLVER;
    public static final int DEFAULT_ARBITRARY_CONTAINER_MAX_SIZE = 3;
    public static final List<MatcherOperator<PropertyGenerator>> DEFAULT_PROPERTY_GENERATORS;
    public static final List<MatcherOperator<CandidateConcretePropertyResolver>> DEFAULT_CANDIDATE_CONCRETE_PROPERTY_RESOLVERS;
    public static final int DEFAULT_MAX_UNIQUE_GENERATION_COUNT = 1000;
    public static final List<MatcherOperator<NullInjectGenerator>> DEFAULT_NULL_INJECT_GENERATORS;
    private final List<MatcherOperator<PropertyGenerator>> propertyGenerators;
    private final PropertyGenerator defaultPropertyGenerator;
    private final List<MatcherOperator<ObjectPropertyGenerator>> objectPropertyGenerators;
    private final ObjectPropertyGenerator defaultObjectPropertyGenerator;
    private final List<MatcherOperator<ContainerPropertyGenerator>> containerPropertyGenerators;
    private final List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers;
    private final PropertyNameResolver defaultPropertyNameResolver;
    private final List<MatcherOperator<NullInjectGenerator>> nullInjectGenerators;
    private final NullInjectGenerator defaultNullInjectGenerator;
    private final List<MatcherOperator<ArbitraryContainerInfoGenerator>> arbitraryContainerInfoGenerators;
    private final ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator;
    private final ArbitraryGenerator defaultArbitraryGenerator;
    private final ArbitraryValidator defaultArbitraryValidator;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    private final int generateMaxTries;
    private final int generateUniqueMaxTries;
    private final JavaConstraintGenerator javaConstraintGenerator;
    private final InstantiatorProcessor instantiatorProcessor;
    private final List<MatcherOperator<CandidateConcretePropertyResolver>> candidateConcretePropertyResolvers;
    private final boolean enableLoggingFail;
    private final List<TreeMatcherOperator<BuilderContextInitializer>> builderContextInitializers;

    public FixtureMonkeyOptions(List<MatcherOperator<PropertyGenerator>> propertyGenerators, PropertyGenerator defaultPropertyGenerator, List<MatcherOperator<ObjectPropertyGenerator>> objectPropertyGenerators, ObjectPropertyGenerator defaultObjectPropertyGenerator, List<MatcherOperator<ContainerPropertyGenerator>> containerPropertyGenerators, List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers, PropertyNameResolver defaultPropertyNameResolver, List<MatcherOperator<NullInjectGenerator>> nullInjectGenerators, NullInjectGenerator defaultNullInjectGenerator, List<MatcherOperator<ArbitraryContainerInfoGenerator>> arbitraryContainerInfoGenerators, ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator, ArbitraryGenerator defaultArbitraryGenerator, ArbitraryValidator defaultArbitraryValidator, DecomposedContainerValueFactory decomposedContainerValueFactory, int generateMaxTries, int generateUniqueMaxTries, JavaConstraintGenerator javaConstraintGenerator, InstantiatorProcessor instantiatorProcessor, List<MatcherOperator<CandidateConcretePropertyResolver>> candidateConcretePropertyResolvers, boolean enableLoggingFail, List<TreeMatcherOperator<BuilderContextInitializer>> builderContextCustomizer) {
        this.propertyGenerators = propertyGenerators;
        this.defaultPropertyGenerator = defaultPropertyGenerator;
        this.objectPropertyGenerators = objectPropertyGenerators;
        this.defaultObjectPropertyGenerator = defaultObjectPropertyGenerator;
        this.containerPropertyGenerators = containerPropertyGenerators;
        this.propertyNameResolvers = propertyNameResolvers;
        this.defaultPropertyNameResolver = defaultPropertyNameResolver;
        this.nullInjectGenerators = nullInjectGenerators;
        this.defaultNullInjectGenerator = defaultNullInjectGenerator;
        this.arbitraryContainerInfoGenerators = arbitraryContainerInfoGenerators;
        this.defaultArbitraryContainerInfoGenerator = defaultArbitraryContainerInfoGenerator;
        this.defaultArbitraryGenerator = defaultArbitraryGenerator;
        this.defaultArbitraryValidator = defaultArbitraryValidator;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.generateMaxTries = generateMaxTries;
        this.generateUniqueMaxTries = generateUniqueMaxTries;
        this.javaConstraintGenerator = javaConstraintGenerator;
        this.instantiatorProcessor = instantiatorProcessor;
        this.candidateConcretePropertyResolvers = candidateConcretePropertyResolvers;
        this.enableLoggingFail = enableLoggingFail;
        this.builderContextInitializers = builderContextCustomizer;
    }

    public static FixtureMonkeyOptionsBuilder builder() {
        return new FixtureMonkeyOptionsBuilder();
    }

    public List<MatcherOperator<PropertyGenerator>> getPropertyGenerators() {
        return this.propertyGenerators;
    }

    @Nullable
    public PropertyGenerator getOptionalPropertyGenerator(Property property) {
        return this.getPropertyGenerators().stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(null);
    }

    public PropertyGenerator getDefaultPropertyGenerator() {
        return this.defaultPropertyGenerator;
    }

    public List<MatcherOperator<ObjectPropertyGenerator>> getObjectPropertyGenerators() {
        return this.objectPropertyGenerators;
    }

    public ObjectPropertyGenerator getObjectPropertyGenerator(Property property) {
        return this.getObjectPropertyGenerators().stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(this.getDefaultObjectPropertyGenerator());
    }

    public ObjectPropertyGenerator getDefaultObjectPropertyGenerator() {
        return this.defaultObjectPropertyGenerator;
    }

    public List<MatcherOperator<ContainerPropertyGenerator>> getContainerPropertyGenerators() {
        return this.containerPropertyGenerators;
    }

    @Nullable
    public ContainerPropertyGenerator getContainerPropertyGenerator(Property property) {
        return this.getContainerPropertyGenerators().stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(null);
    }

    public List<MatcherOperator<PropertyNameResolver>> getPropertyNameResolvers() {
        return this.propertyNameResolvers;
    }

    public PropertyNameResolver getPropertyNameResolver(Property property) {
        return this.getPropertyNameResolvers().stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(this.getDefaultPropertyNameResolver());
    }

    public PropertyNameResolver getDefaultPropertyNameResolver() {
        return this.defaultPropertyNameResolver;
    }

    public List<MatcherOperator<NullInjectGenerator>> getNullInjectGenerators() {
        return this.nullInjectGenerators;
    }

    public NullInjectGenerator getNullInjectGenerator(Property property) {
        return this.getNullInjectGenerators().stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(this.getDefaultNullInjectGenerator());
    }

    public NullInjectGenerator getDefaultNullInjectGenerator() {
        return this.defaultNullInjectGenerator;
    }

    public List<MatcherOperator<ArbitraryContainerInfoGenerator>> getArbitraryContainerInfoGenerators() {
        return this.arbitraryContainerInfoGenerators;
    }

    public ArbitraryContainerInfoGenerator getArbitraryContainerInfoGenerator(Property property) {
        return this.getArbitraryContainerInfoGenerators().stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(this.getDefaultArbitraryContainerInfoGenerator());
    }

    public ArbitraryContainerInfoGenerator getDefaultArbitraryContainerInfoGenerator() {
        return this.defaultArbitraryContainerInfoGenerator;
    }

    public ArbitraryGenerator getDefaultArbitraryGenerator() {
        return this.defaultArbitraryGenerator;
    }

    public ArbitraryValidator getDefaultArbitraryValidator() {
        return this.defaultArbitraryValidator;
    }

    public DecomposedContainerValueFactory getDecomposedContainerValueFactory() {
        return this.decomposedContainerValueFactory;
    }

    public int getGenerateMaxTries() {
        return this.generateMaxTries;
    }

    public int getGenerateUniqueMaxTries() {
        return this.generateUniqueMaxTries;
    }

    public JavaConstraintGenerator getJavaConstraintGenerator() {
        return this.javaConstraintGenerator;
    }

    public InstantiatorProcessor getInstantiatorProcessor() {
        return this.instantiatorProcessor;
    }

    public boolean isEnableLoggingFail() {
        return this.enableLoggingFail;
    }

    public List<TreeMatcherOperator<BuilderContextInitializer>> getBuilderContextInitializers() {
        return this.builderContextInitializers;
    }

    public List<MatcherOperator<CandidateConcretePropertyResolver>> getCandidateConcretePropertyResolvers() {
        return this.candidateConcretePropertyResolvers;
    }

    @Nullable
    @Deprecated
    public CandidateConcretePropertyResolver getCandidateConcretePropertyResolver(Property property) {
        List<CandidateConcretePropertyResolver> candidateConcretePropertyResolverList = this.candidateConcretePropertyResolvers.stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).collect(Collectors.toList());
        if (candidateConcretePropertyResolverList.isEmpty()) {
            return null;
        }
        return new CompositeCandidateConcretePropertyResolver(candidateConcretePropertyResolverList);
    }

    public FixtureMonkeyOptionsBuilder toBuilder() {
        return FixtureMonkeyOptions.builder().defaultPropertyGenerator(this.defaultPropertyGenerator).arbitraryObjectPropertyGenerators(this.objectPropertyGenerators).defaultObjectPropertyGenerator(this.defaultObjectPropertyGenerator).arbitraryContainerPropertyGenerators(this.containerPropertyGenerators).propertyNameResolvers(new ArrayList<MatcherOperator<PropertyNameResolver>>(this.propertyNameResolvers)).defaultPropertyNameResolver(this.defaultPropertyNameResolver).nullInjectGenerators(new ArrayList<MatcherOperator<NullInjectGenerator>>(this.nullInjectGenerators)).defaultNullInjectGenerator(this.defaultNullInjectGenerator).arbitraryContainerInfoGenerators(new ArrayList<MatcherOperator<ArbitraryContainerInfoGenerator>>(this.arbitraryContainerInfoGenerators)).defaultArbitraryContainerInfoGenerator(this.defaultArbitraryContainerInfoGenerator).defaultArbitraryValidator(this.defaultArbitraryValidator).decomposedContainerValueFactory(this.decomposedContainerValueFactory).javaConstraintGenerator(this.javaConstraintGenerator).instantiatorProcessor(this.instantiatorProcessor).candidateConcretePropertyResolvers(this.candidateConcretePropertyResolvers).builderContextInitializers(this.builderContextInitializers);
    }

    private static List<MatcherOperator<ContainerPropertyGenerator>> getDefaultContainerPropertyGenerators() {
        return Arrays.asList(new MatcherOperator<FunctionalInterfaceContainerPropertyGenerator>(new AssignableTypeMatcher(Supplier.class).intersect(new SingleGenericTypeMatcher()).union(new AssignableTypeMatcher(Function.class).intersect(new DoubleGenericTypeMatcher())), FunctionalInterfaceContainerPropertyGenerator.INSTANCE), new MatcherOperator<OptionalContainerPropertyGenerator>(new AssignableTypeMatcher(Optional.class).intersect(new SingleGenericTypeMatcher()), OptionalContainerPropertyGenerator.INSTANCE), MatcherOperator.exactTypeMatchOperator(OptionalInt.class, OptionalContainerPropertyGenerator.INSTANCE), MatcherOperator.exactTypeMatchOperator(OptionalLong.class, OptionalContainerPropertyGenerator.INSTANCE), MatcherOperator.exactTypeMatchOperator(OptionalDouble.class, OptionalContainerPropertyGenerator.INSTANCE), new MatcherOperator<StreamContainerPropertyGenerator>(new AssignableTypeMatcher(Stream.class).intersect(new SingleGenericTypeMatcher()), StreamContainerPropertyGenerator.INSTANCE), MatcherOperator.assignableTypeMatchOperator(IntStream.class, StreamContainerPropertyGenerator.INSTANCE), MatcherOperator.assignableTypeMatchOperator(LongStream.class, StreamContainerPropertyGenerator.INSTANCE), MatcherOperator.assignableTypeMatchOperator(DoubleStream.class, StreamContainerPropertyGenerator.INSTANCE), new MatcherOperator<SetContainerPropertyGenerator>(new AssignableTypeMatcher(Set.class).intersect(new SingleGenericTypeMatcher()), SetContainerPropertyGenerator.INSTANCE), new MatcherOperator<DefaultSingleContainerPropertyGenerator>(new AssignableTypeMatcher(Iterable.class).intersect(new SingleGenericTypeMatcher()), DefaultSingleContainerPropertyGenerator.INSTANCE), new MatcherOperator<DefaultSingleContainerPropertyGenerator>(new AssignableTypeMatcher(Iterator.class).intersect(new SingleGenericTypeMatcher()), DefaultSingleContainerPropertyGenerator.INSTANCE), new MatcherOperator<MapContainerPropertyGenerator>(new AssignableTypeMatcher(Map.class).intersect(new DoubleGenericTypeMatcher()), MapContainerPropertyGenerator.INSTANCE), new MatcherOperator<EntryContainerPropertyGenerator>(new AssignableTypeMatcher(Map.Entry.class).intersect(new DoubleGenericTypeMatcher()), EntryContainerPropertyGenerator.INSTANCE), new MatcherOperator<ArrayContainerPropertyGenerator>(property -> Types.getActualType(property.getType()).isArray() || GenericArrayType.class.isAssignableFrom(property.getType().getClass()), ArrayContainerPropertyGenerator.INSTANCE), new MatcherOperator<MapEntryElementContainerPropertyGenerator>(new ExactPropertyMatcher(MapEntryElementProperty.class), MapEntryElementContainerPropertyGenerator.INSTANCE));
    }

    private static List<MatcherOperator<PropertyGenerator>> getDefaultPropertyGenerators() {
        return Arrays.asList(new MatcherOperator<PropertyGenerator>(ConstantIntrospector.INSTANCE, EmptyPropertyGenerator.INSTANCE), new MatcherOperator<PropertyGenerator>(property -> {
            Class<?> actualType = Types.getActualType(property.getType());
            if (actualType.isPrimitive()) return true;
            if (!DEFAULT_JAVA_PACKAGES.stream().anyMatch(actualType.getPackage().getName()::startsWith)) return false;
            return true;
        }, EmptyPropertyGenerator.INSTANCE), new MatcherOperator<PropertyGenerator>(Matchers.ENUM_TYPE_MATCHER, EmptyPropertyGenerator.INSTANCE), new MatcherOperator<NoArgumentInterfaceJavaMethodPropertyGenerator>(p -> Modifier.isInterface(Types.getActualType(p.getType()).getModifiers()), new NoArgumentInterfaceJavaMethodPropertyGenerator()));
    }

    static {
        DEFAULT_CONTAINER_PROPERTY_GENERATORS = FixtureMonkeyOptions.getDefaultContainerPropertyGenerators();
        DEFAULT_ARBITRARY_INTROSPECTORS = Arrays.asList(MatcherOperator.exactTypeMatchOperator(Types.UnidentifiableType.class, NullArbitraryIntrospector.INSTANCE), new MatcherOperator<ConstantIntrospector>(ConstantIntrospector.INSTANCE, ConstantIntrospector.INSTANCE), MatcherOperator.exactTypeMatchOperator(Types.GeneratingWildcardType.class, context -> new ArbitraryIntrospectorResult(CombinableArbitrary.from(new Object()))));
        DEFAULT_OBJECT_PROPERTY_GENERATOR = DefaultObjectPropertyGenerator.INSTANCE;
        DEFAULT_PROPERTY_NAME_RESOLVER = PropertyNameResolver.IDENTITY;
        DEFAULT_PROPERTY_GENERATORS = FixtureMonkeyOptions.getDefaultPropertyGenerators();
        DEFAULT_CANDIDATE_CONCRETE_PROPERTY_RESOLVERS = Arrays.asList(MatcherOperator.exactTypeMatchOperator(List.class, new ConcreteTypeCandidateConcretePropertyResolver(Collections.singletonList(ArrayList.class))), MatcherOperator.exactTypeMatchOperator(Set.class, new ConcreteTypeCandidateConcretePropertyResolver(Collections.singletonList(HashSet.class))));
        DEFAULT_NULL_INJECT_GENERATORS = Collections.singletonList(new MatcherOperator<NullInjectGenerator>(ConstantIntrospector.INSTANCE, context -> 0.0));
        ArrayList<String> defaultJavaPackages = new ArrayList<String>();
        defaultJavaPackages.add("java.lang");
        defaultJavaPackages.add("java.net");
        defaultJavaPackages.add("java.util");
        defaultJavaPackages.add("java.math");
        defaultJavaPackages.add("java.time");
        defaultJavaPackages.add("jdk.internal.reflect");
        defaultJavaPackages.add("sun.reflect");
        defaultJavaPackages.add("sun.util");
        DEFAULT_JAVA_PACKAGES = Collections.unmodifiableList(defaultJavaPackages);
    }

    private static class EmptyPropertyGenerator
    implements PropertyGenerator {
        private static final PropertyGenerator INSTANCE = new EmptyPropertyGenerator();

        private EmptyPropertyGenerator() {
        }

        @Override
        public List<Property> generateChildProperties(Property property) {
            return Collections.emptyList();
        }
    }
}

