/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.5.3", status=API.Status.MAINTAINED)
public final class CompositePropertyGenerator
implements PropertyGenerator {
    private final List<PropertyGenerator> propertyGenerators;

    public CompositePropertyGenerator(List<PropertyGenerator> propertyGenerators) {
        this.propertyGenerators = propertyGenerators;
    }

    @Override
    public List<Property> generateChildProperties(Property property) {
        HashMap<String, List> propertyListsByPropertyName = new HashMap<String, List>();
        for (PropertyGenerator propertyGenerator : this.propertyGenerators) {
            List generatedProperties = propertyGenerator.generateChildProperties(property).stream().filter(it -> it.getName() != null).collect(Collectors.toList());
            for (Property generatedProperty : generatedProperties) {
                List properties2 = propertyListsByPropertyName.computeIfAbsent(generatedProperty.getName(), name -> new ArrayList());
                properties2.add(generatedProperty);
            }
        }
        return Collections.unmodifiableList(propertyListsByPropertyName.values().stream().map(properties -> {
            if (properties.size() == 1) {
                return (Property)properties.get(0);
            }
            return new CompositeProperty((Property)properties.get(0), (Property)properties.get(1));
        }).collect(Collectors.toList()));
    }
}

