/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.1.7", status=API.Status.EXPERIMENTAL)
public final class ConcreteTypeProperty
implements Property {
    private final AnnotatedType concreteAnnotatedType;
    private final Property abstractTypeProperty;
    private final List<Annotation> annotations;

    public ConcreteTypeProperty(AnnotatedType concreteAnnotatedType, Property abstractTypeProperty) {
        this.concreteAnnotatedType = concreteAnnotatedType;
        this.abstractTypeProperty = abstractTypeProperty;
        this.annotations = Collections.emptyList();
    }

    public ConcreteTypeProperty(AnnotatedType concreteAnnotatedType, Property abstractTypeProperty, List<Annotation> annotations) {
        this.concreteAnnotatedType = concreteAnnotatedType;
        this.abstractTypeProperty = abstractTypeProperty;
        this.annotations = annotations;
    }

    @Override
    public Type getType() {
        return this.concreteAnnotatedType.getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.concreteAnnotatedType;
    }

    @Override
    @Nullable
    public String getName() {
        return this.abstractTypeProperty.getName();
    }

    @Override
    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> concatAnnotations = new ArrayList<Annotation>(this.annotations);
        concatAnnotations.addAll(Arrays.asList(this.concreteAnnotatedType.getAnnotations()));
        concatAnnotations.addAll(this.abstractTypeProperty.getAnnotations());
        return Collections.unmodifiableList(concatAnnotations);
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        return this.abstractTypeProperty.getValue(instance);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConcreteTypeProperty that = (ConcreteTypeProperty)obj;
        return Objects.equals(this.concreteAnnotatedType.getType(), that.concreteAnnotatedType.getType()) && Objects.equals(this.abstractTypeProperty, that.abstractTypeProperty) && Objects.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.concreteAnnotatedType.getType(), this.abstractTypeProperty, this.annotations);
    }
}

