/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class PropertyDescriptorProperty
implements Property {
    private final AnnotatedType annotatedType;
    private final PropertyDescriptor propertyDescriptor;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

    public PropertyDescriptorProperty(PropertyDescriptor propertyDescriptor) {
        this(TypeCache.getAnnotatedType(propertyDescriptor), propertyDescriptor);
    }

    public PropertyDescriptorProperty(AnnotatedType annotatedType, PropertyDescriptor propertyDescriptor) {
        this.annotatedType = annotatedType;
        this.propertyDescriptor = propertyDescriptor;
        ArrayList<Annotation> concatAnnotations = new ArrayList<Annotation>();
        if (propertyDescriptor.getWriteMethod() != null) {
            concatAnnotations.addAll(Arrays.asList(propertyDescriptor.getWriteMethod().getAnnotations()));
        }
        if (propertyDescriptor.getReadMethod() != null) {
            concatAnnotations.addAll(Arrays.asList(propertyDescriptor.getReadMethod().getAnnotations()));
        }
        this.annotations = Collections.unmodifiableList(concatAnnotations);
        this.annotationsMap = this.annotations.stream().collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a1, a2) -> a1));
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public String getName() {
        return this.propertyDescriptor.getName();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        try {
            return this.propertyDescriptor.getReadMethod().invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Can not invoke value. obj: " + instance.toString() + ", propertyName: " + this.propertyDescriptor.getName(), ex);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescriptorProperty that = (PropertyDescriptorProperty)obj;
        return this.annotatedType.getType().equals(that.annotatedType.getType()) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedType.getType(), this.annotations);
    }

    public String toString() {
        return "PropertyDescriptorProperty{annotatedType=" + this.annotatedType + ", propertyDescriptor=" + this.propertyDescriptor + '}';
    }
}

