/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.1.6", status=API.Status.EXPERIMENTAL)
public final class TypeNameProperty
implements Property {
    private final AnnotatedType annotatedType;
    private final String typeName;
    @Nullable
    private final Boolean nullable;

    public TypeNameProperty(AnnotatedType annotatedType, String typeName, @Nullable Boolean nullable) {
        this.annotatedType = annotatedType;
        this.typeName = typeName;
        this.nullable = nullable;
    }

    @Override
    public Type getType() {
        return this.annotatedType.getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    @Nullable
    public String getName() {
        return this.typeName;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Arrays.asList(this.annotatedType.getAnnotations());
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Boolean isNullable() {
        return this.nullable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeNameProperty that = (TypeNameProperty)obj;
        return Objects.equals(this.annotatedType, that.annotatedType) && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.nullable, that.nullable);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedType, this.typeName, this.nullable);
    }
}

