/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.generator;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.generator.AbstractArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.FieldArbitraries;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;

public final class JacksonArbitraryGenerator
extends AbstractArbitraryGenerator {
    public static final JacksonArbitraryGenerator INSTANCE = new JacksonArbitraryGenerator();
    private final ObjectMapper objectMapper;
    private final ArbitraryCustomizers arbitraryCustomizers;

    public JacksonArbitraryGenerator() {
        this(FixtureMonkeyJackson.defaultObjectMapper(), new ArbitraryCustomizers());
    }

    public JacksonArbitraryGenerator(ObjectMapper objectMapper) {
        this(objectMapper, new ArbitraryCustomizers());
    }

    private JacksonArbitraryGenerator(ObjectMapper objectMapper, ArbitraryCustomizers arbitraryCustomizers) {
        this.objectMapper = objectMapper.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS) ? objectMapper.copy().configure(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS, false) : objectMapper;
        this.arbitraryCustomizers = arbitraryCustomizers;
    }

    protected <T> Arbitrary<T> generateObject(ArbitraryType type, List<ArbitraryNode> nodes) {
        FieldArbitraries fieldArbitraries = new FieldArbitraries(this.toArbitrariesByFieldName(nodes, ArbitraryNode::getFieldName, this::formatValue));
        this.arbitraryCustomizers.customizeFields(type.getType(), fieldArbitraries);
        Combinators.BuilderCombinator builderCombinator = Combinators.withBuilder(HashMap::new);
        for (Map.Entry entry : fieldArbitraries.entrySet()) {
            String fieldName = (String)entry.getKey();
            Arbitrary parameterArbitrary = (Arbitrary)entry.getValue();
            builderCombinator = builderCombinator.use(parameterArbitrary).in((map, value) -> {
                if (value != null) {
                    map.put(fieldName, value);
                }
                return map;
            });
        }
        return builderCombinator.build(map -> {
            Class clazz = type.getType();
            Object fixture = this.objectMapper.convertValue(map, clazz);
            return this.arbitraryCustomizers.customizeFixture(clazz, fixture);
        });
    }

    private <T> Arbitrary<T> formatValue(ArbitraryNode<T> node, Arbitrary<T> arbitrary) {
        ArbitraryType nodeType = node.getType();
        JsonFormat jsonFormat = (JsonFormat)nodeType.getAnnotation(JsonFormat.class);
        if (jsonFormat != null) {
            return arbitrary.map(it -> this.format(it, jsonFormat));
        }
        return arbitrary;
    }

    private Object format(Object object, JsonFormat jsonFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(jsonFormat.pattern());
        if (object instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return dateTimeFormatter.format(temporalAccessor);
        }
        if (object instanceof Date) {
            LocalDate dateTemporalAccessor = ((Date)object).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return dateTimeFormatter.format(dateTemporalAccessor);
        }
        if (object instanceof Enum && jsonFormat.shape().isNumeric()) {
            return ((Enum)object).ordinal();
        }
        return object;
    }

    public ArbitraryGenerator withFixtureCustomizers(ArbitraryCustomizers arbitraryCustomizers) {
        if (this.arbitraryCustomizers == arbitraryCustomizers) {
            return this;
        }
        return new JacksonArbitraryGenerator(this.objectMapper, arbitraryCustomizers);
    }

    public String resolveFieldName(Field field) {
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        if (jsonProperty == null) {
            return field.getName();
        }
        return jsonProperty.value();
    }
}

