/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
public final class JacksonCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private final CombinableArbitrary<T> jsonValue;
    private final Function<Object, T> deserializer;

    public JacksonCombinableArbitrary(CombinableArbitrary<T> jsonValue, Function<Object, T> deserializer) {
        this.jsonValue = jsonValue;
        this.deserializer = deserializer;
    }

    public T combined() {
        return this.deserializer.apply(this.jsonValue.rawValue());
    }

    public Object rawValue() {
        return this.jsonValue.rawValue();
    }

    public void clear() {
        this.jsonValue.clear();
    }

    public boolean fixed() {
        return false;
    }
}

