/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.plugin;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.MatchArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptionsBuilder;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import com.navercorp.fixturemonkey.jackson.generator.ElementJsonSubTypesObjectPropertyGenerator;
import com.navercorp.fixturemonkey.jackson.generator.JsonNodeContainerPropertyGenerator;
import com.navercorp.fixturemonkey.jackson.generator.PropertyJsonSubTypesObjectPropertyGenerator;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonArrayArbitraryIntrospector;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonCollectionArbitraryIntrospector;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonMapArbitraryIntrospector;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonObjectArbitraryIntrospector;
import com.navercorp.fixturemonkey.jackson.introspector.JsonNodeIntrospector;
import com.navercorp.fixturemonkey.jackson.property.JacksonAnnotations;
import com.navercorp.fixturemonkey.jackson.property.JacksonPropertyNameResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class JacksonPlugin
implements Plugin {
    private final ObjectMapper objectMapper;
    private final List<Matcher> matchers = new ArrayList<Matcher>();
    private boolean defaultOptions = true;

    public JacksonPlugin(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonPlugin() {
        this(FixtureMonkeyJackson.defaultObjectMapper());
    }

    public JacksonPlugin by(Matcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public JacksonPlugin by(Class<?> matchType) {
        this.matchers.add((Matcher)new AssignableTypeMatcher(matchType));
        return this;
    }

    public JacksonPlugin defaultOptions(boolean defaultOptions) {
        this.defaultOptions = defaultOptions;
        return this;
    }

    public void accept(FixtureMonkeyOptionsBuilder optionsBuilder) {
        if (!this.matchers.isEmpty()) {
            Matcher matcher = property -> this.matchers.stream().anyMatch(it -> it.match(property));
            optionsBuilder.insertFirstArbitraryIntrospector(matcher, (ArbitraryIntrospector)new JacksonObjectArbitraryIntrospector(this.objectMapper)).insertFirstPropertyNameResolver(matcher, (PropertyNameResolver)new JacksonPropertyNameResolver());
        }
        if (this.defaultOptions) {
            optionsBuilder.objectIntrospector(it -> new JacksonObjectArbitraryIntrospector(this.objectMapper)).defaultPropertyNameResolver((PropertyNameResolver)new JacksonPropertyNameResolver()).containerIntrospector(container -> new MatchArbitraryIntrospector(Arrays.asList(new JacksonCollectionArbitraryIntrospector(this.objectMapper), new JacksonArrayArbitraryIntrospector(this.objectMapper), new JacksonMapArbitraryIntrospector(this.objectMapper), container))).insertFirstArbitraryObjectPropertyGenerator(property -> JacksonAnnotations.getJacksonAnnotation(property, JsonSubTypes.class) != null, (ObjectPropertyGenerator)PropertyJsonSubTypesObjectPropertyGenerator.INSTANCE).insertFirstArbitraryObjectPropertyGenerator(property -> property instanceof ElementProperty && JacksonAnnotations.getJacksonAnnotation(((ElementProperty)property).getContainerProperty(), JsonSubTypes.class) != null, (ObjectPropertyGenerator)ElementJsonSubTypesObjectPropertyGenerator.INSTANCE);
        }
        optionsBuilder.insertFirstArbitraryContainerPropertyGenerator(JsonNode.class, (ContainerPropertyGenerator)JsonNodeContainerPropertyGenerator.INSTANCE).insertFirstArbitraryIntrospector(JsonNode.class, (ArbitraryIntrospector)JsonNodeIntrospector.INSTANCE);
    }
}

