/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.generator;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyUtils;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.jackson.property.JacksonAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.2", status=API.Status.MAINTAINED)
public final class ElementJsonSubTypesObjectPropertyGenerator
implements ObjectPropertyGenerator {
    public static final ElementJsonSubTypesObjectPropertyGenerator INSTANCE = new ElementJsonSubTypesObjectPropertyGenerator();

    public ObjectProperty generate(ObjectPropertyGeneratorContext context) {
        final Property property = context.getProperty();
        double nullInject = context.getNullInjectGenerator().generate(context);
        PropertyGenerator propertyGenerator = context.getPropertyGenerator();
        Property containerProperty = ((ElementProperty)property).getContainerProperty();
        JsonSubTypes jsonSubTypes = JacksonAnnotations.getJacksonAnnotation(containerProperty, JsonSubTypes.class);
        if (jsonSubTypes == null) {
            throw new IllegalArgumentException("@JsonSubTypes is not found " + property.getType().getTypeName());
        }
        final Class<?> type = JacksonAnnotations.getRandomJsonSubType(jsonSubTypes);
        final AnnotatedType annotatedType = Types.generateAnnotatedTypeWithoutAnnotation(type);
        List childProperties = propertyGenerator.generateChildProperties(PropertyUtils.toProperty((AnnotatedType)annotatedType));
        JsonTypeInfo jsonTypeInfo = JacksonAnnotations.getJacksonAnnotation(containerProperty, JsonTypeInfo.class);
        final ArrayList<JsonTypeInfo> annotations = new ArrayList<JsonTypeInfo>(property.getAnnotations());
        annotations.add(jsonTypeInfo);
        Property actualProperty = new Property(){

            public Type getType() {
                return type;
            }

            public AnnotatedType getAnnotatedType() {
                return annotatedType;
            }

            @Nullable
            public String getName() {
                return property.getName();
            }

            public List<Annotation> getAnnotations() {
                return Collections.unmodifiableList(annotations);
            }

            @Nullable
            public Object getValue(Object instance) {
                return property.getValue(instance);
            }
        };
        return new ObjectProperty(actualProperty, context.getPropertyNameResolver(), nullInject, context.getElementIndex(), Collections.singletonMap(actualProperty, childProperties));
    }
}

