/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.introspector;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonCombinableArbitrary;
import com.navercorp.fixturemonkey.jackson.type.JacksonTypeReference;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.MAINTAINED)
public final class JacksonArrayArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    public static final JacksonArrayArbitraryIntrospector INSTANCE = new JacksonArrayArbitraryIntrospector(FixtureMonkeyJackson.defaultObjectMapper());
    private final ObjectMapper objectMapper;

    public JacksonArrayArbitraryIntrospector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean match(Property property) {
        return Types.getActualType((Type)property.getType()).isArray();
    }

    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        final Property property = context.getResolvedProperty();
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        JavaType elementType = typeFactory.constructType((TypeReference)new JacksonTypeReference<Object>(){

            @Override
            public Type getType() {
                return Types.getArrayComponentAnnotatedType((AnnotatedType)property.getAnnotatedType()).getType();
            }
        });
        ArrayType arrayType = TypeFactory.defaultInstance().constructArrayType(elementType);
        CombinableArbitrary listCombinableArbitrary = CombinableArbitrary.containerBuilder().elements(context.getElementCombinableArbitraryList()).build(ArrayList::new);
        return new ArbitraryIntrospectorResult(new JacksonCombinableArbitrary<Object>(listCombinableArbitrary, list -> this.objectMapper.convertValue(list, (JavaType)arrayType)));
    }
}

