/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.introspector;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonCombinableArbitrary;
import com.navercorp.fixturemonkey.jackson.type.JacksonTypeReference;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.MAINTAINED)
public final class JacksonCollectionArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    public static final JacksonCollectionArbitraryIntrospector INSTANCE = new JacksonCollectionArbitraryIntrospector(FixtureMonkeyJackson.defaultObjectMapper());
    private final ObjectMapper objectMapper;

    public JacksonCollectionArbitraryIntrospector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean match(Property property) {
        return Collection.class.isAssignableFrom(Types.getActualType((Type)property.getType()));
    }

    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class containerType = Types.getActualType((Type)property.getType());
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        final AnnotatedType elementAnnotatedType = (AnnotatedType)Types.getGenericsTypes((AnnotatedType)property.getAnnotatedType()).get(0);
        JavaType elementType = typeFactory.constructType((TypeReference)new JacksonTypeReference<Object>(){

            @Override
            public Type getType() {
                return elementAnnotatedType.getType();
            }
        });
        CollectionType collectionType = typeFactory.constructCollectionType(containerType, elementType);
        List elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        CombinableArbitrary listCombinableArbitrary = CombinableArbitrary.containerBuilder().elements(elementCombinableArbitraryList).build(ArrayList::new);
        return new ArbitraryIntrospectorResult(new JacksonCombinableArbitrary<Object>(listCombinableArbitrary, list -> this.objectMapper.convertValue(list, (JavaType)collectionType)));
    }
}

