/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.introspector;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.MapIntrospector;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonCombinableArbitrary;
import com.navercorp.fixturemonkey.jackson.type.JacksonTypeReference;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.MAINTAINED)
public final class JacksonMapArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    public static final JacksonMapArbitraryIntrospector INSTANCE = new JacksonMapArbitraryIntrospector(FixtureMonkeyJackson.defaultObjectMapper());
    private static final ArbitraryIntrospector DELEGATOR = new MapIntrospector();
    private final ObjectMapper objectMapper;

    public JacksonMapArbitraryIntrospector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean match(Property property) {
        return Map.class.isAssignableFrom(Types.getActualType((Type)property.getType()));
    }

    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        Property property = context.getResolvedProperty();
        Class containerType = Types.getActualType((Type)property.getType());
        final AnnotatedType keyAnnotatedType = (AnnotatedType)Types.getGenericsTypes((AnnotatedType)property.getAnnotatedType()).get(0);
        final AnnotatedType valueAnnotatedType = (AnnotatedType)Types.getGenericsTypes((AnnotatedType)property.getAnnotatedType()).get(1);
        JavaType keyType = typeFactory.constructType((TypeReference)new JacksonTypeReference<Object>(){

            @Override
            public Type getType() {
                return keyAnnotatedType.getType();
            }
        });
        JavaType valueType = typeFactory.constructType((TypeReference)new JacksonTypeReference<Object>(){

            @Override
            public Type getType() {
                return valueAnnotatedType.getType();
            }
        });
        MapType mapType = typeFactory.constructMapType(containerType, keyType, valueType);
        return new ArbitraryIntrospectorResult(new JacksonCombinableArbitrary<Object>(DELEGATOR.introspect(context).getValue(), arg_0 -> this.lambda$introspect$0((MapLikeType)mapType, arg_0)));
    }

    private /* synthetic */ Object lambda$introspect$0(MapLikeType mapType, Object list) {
        return this.objectMapper.convertValue(list, (JavaType)mapType);
    }
}

