/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.introspector;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.ConstructorProperty;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyDescriptorProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import com.navercorp.fixturemonkey.jackson.introspector.JacksonCombinableArbitrary;
import com.navercorp.fixturemonkey.jackson.property.JacksonAnnotations;
import com.navercorp.fixturemonkey.jackson.type.JacksonTypeReference;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.5.5", status=API.Status.MAINTAINED)
public final class JacksonObjectArbitraryIntrospector
implements ArbitraryIntrospector {
    public static final JacksonObjectArbitraryIntrospector INSTANCE = new JacksonObjectArbitraryIntrospector(FixtureMonkeyJackson.defaultObjectMapper());
    private final ObjectMapper objectMapper;

    public JacksonObjectArbitraryIntrospector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        final Property property = context.getResolvedProperty();
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        JavaType type = typeFactory.constructType((TypeReference)new JacksonTypeReference<Object>(){

            @Override
            public Type getType() {
                return property.getType();
            }
        });
        return new ArbitraryIntrospectorResult(new JacksonCombinableArbitrary<Object>(CombinableArbitrary.objectBuilder().properties(context.getCombinableArbitrariesByArbitraryProperty()).build(this.combineAsJson(property)), map -> this.objectMapper.convertValue(map, type)));
    }

    private Function<Map<ArbitraryProperty, Object>, Object> combineAsJson(Property property) {
        return propertyValuesByArbitraryProperty -> {
            Map<String, Object> map = this.initializeMap(property);
            propertyValuesByArbitraryProperty.entrySet().stream().filter(it -> this.isJacksonSerializableProperty(((ArbitraryProperty)it.getKey()).getObjectProperty().getProperty())).forEach(entry -> {
                ArbitraryProperty arbitraryProperty = (ArbitraryProperty)entry.getKey();
                Object value = entry.getValue();
                String resolvePropertyName = arbitraryProperty.getObjectProperty().getResolvedPropertyName();
                if (value != null) {
                    Object jsonFormatted = arbitraryProperty.getObjectProperty().getProperty().getAnnotation(JsonFormat.class).map(it -> this.format(value, (JsonFormat)it)).orElse(value);
                    JsonTypeInfo jsonTypeInfo = JacksonAnnotations.getJacksonAnnotation(property, JsonTypeInfo.class);
                    if (jsonTypeInfo == null) {
                        map.put(resolvePropertyName, jsonFormatted);
                    } else if (jsonTypeInfo.include() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                        String typeIdentifier = this.getJsonTypeInfoIdentifier(jsonTypeInfo, property);
                        Map typeJson = map.getOrDefault(typeIdentifier, new HashMap());
                        typeJson.put(resolvePropertyName, jsonFormatted);
                        map.put(typeIdentifier, typeJson);
                    }
                }
            });
            return map;
        };
    }

    private Map<String, Object> initializeMap(Property property) {
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        JsonTypeInfo jsonTypeInfo = JacksonAnnotations.getJacksonAnnotation(property, JsonTypeInfo.class);
        if (jsonTypeInfo == null || jsonTypeInfo.include() == JsonTypeInfo.As.WRAPPER_OBJECT) {
            return defaultMap;
        }
        String jsonTypeInfoValue = this.getJsonTypeInfoIdentifier(jsonTypeInfo, property);
        String jsonTypeInfoPropertyName = this.getJsonTypeInfoPropertyName(jsonTypeInfo);
        defaultMap.put(jsonTypeInfoPropertyName, jsonTypeInfoValue);
        return defaultMap;
    }

    private String getJsonTypeInfoPropertyName(JsonTypeInfo jsonTypeInfo) {
        return "".equals(jsonTypeInfo.property()) ? jsonTypeInfo.use().getDefaultPropertyName() : jsonTypeInfo.property();
    }

    private String getJsonTypeInfoIdentifier(JsonTypeInfo jsonTypeInfo, Property property) {
        String jsonTypeInfoValue;
        JsonTypeName jsonTypeName = JacksonAnnotations.getJacksonAnnotation(property, JsonTypeName.class);
        Class type = Types.getActualType((Type)property.getType());
        JsonTypeInfo.Id id = jsonTypeInfo.use();
        switch (id) {
            case NAME: {
                if (jsonTypeName != null) {
                    jsonTypeInfoValue = jsonTypeName.value();
                    break;
                }
                jsonTypeInfoValue = type.getSimpleName();
                break;
            }
            case CLASS: {
                jsonTypeInfoValue = type.getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported JsonTypeInfo Id : " + id.name());
            }
        }
        return jsonTypeInfoValue;
    }

    private Object format(Object object, JsonFormat jsonFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(jsonFormat.pattern()).withZone(ZoneId.systemDefault());
        if (object instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return dateTimeFormatter.format(temporalAccessor);
        }
        if (object instanceof Date) {
            LocalDate dateTemporalAccessor = ((Date)object).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return dateTimeFormatter.format(dateTemporalAccessor);
        }
        if (object instanceof Enum && jsonFormat.shape().isNumeric()) {
            return ((Enum)object).ordinal();
        }
        return object;
    }

    private boolean isJacksonSerializableProperty(Property property) {
        if (property instanceof CompositeProperty) {
            CompositeProperty compositeProperty = (CompositeProperty)property;
            return this.isJacksonSerializableProperty(compositeProperty.getPrimaryProperty()) || this.isJacksonSerializableProperty(compositeProperty.getSecondaryProperty());
        }
        return property instanceof FieldProperty || property instanceof PropertyDescriptorProperty || property instanceof ConstructorProperty;
    }
}

