/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.introspector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.jackson.FixtureMonkeyJackson;
import java.util.HashMap;
import org.apiguardian.api.API;

@API(since="0.4.3", status=API.Status.MAINTAINED)
public final class JsonNodeIntrospector
implements ArbitraryIntrospector {
    public static final JsonNodeIntrospector INSTANCE = new JsonNodeIntrospector(FixtureMonkeyJackson.defaultObjectMapper());
    private final ObjectMapper objectMapper;

    public JsonNodeIntrospector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer()) {
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(context.getElementCombinableArbitraryList()).build(elements -> {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Object element : elements) {
                MapEntryElementProperty.MapEntryElementType mapEntryElementType = (MapEntryElementProperty.MapEntryElementType)element;
                if (mapEntryElementType.getKey() == null) {
                    throw new IllegalArgumentException("Map key cannot be null.");
                }
                map.put(mapEntryElementType.getKey(), mapEntryElementType.getValue());
            }
            return (JsonNode)this.objectMapper.convertValue(map, JsonNode.class);
        }));
    }
}

