/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jackson.property;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.2", status=API.Status.MAINTAINED)
public abstract class JacksonAnnotations {
    @Nullable
    public static <T extends Annotation> T getJacksonAnnotation(Property property, Class<T> annotationClass) {
        Annotation propertyAnnotation = property.getAnnotation(annotationClass).orElse(null);
        if (propertyAnnotation != null) {
            return (T)propertyAnnotation;
        }
        Class type = Types.getActualType((Type)property.getType());
        return type.getAnnotation(annotationClass);
    }

    public static Class<?> getRandomJsonSubType(JsonSubTypes jsonSubTypes) {
        JsonSubTypes.Type[] types = jsonSubTypes.value();
        int random = Randoms.nextInt((int)types.length);
        return types[random].value();
    }
}

