/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jakarta.validation.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfoGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.MAINTAINED)
public final class JakartaValidationArbitraryContainerInfoGenerator
implements ArbitraryContainerInfoGenerator {
    public static final Set<Class<? extends Annotation>> JAKARTA_VALIDATION_CONTAINER_ANNOTATIONS;

    public ArbitraryContainerInfo generate(ContainerPropertyGeneratorContext context) {
        Integer min = null;
        Integer max = null;
        Optional sizeAnnotation = context.getProperty().getAnnotation(Size.class);
        if (sizeAnnotation.isPresent()) {
            Size size = (Size)sizeAnnotation.get();
            min = size.min();
            max = size.max() != Integer.MAX_VALUE ? Integer.valueOf(size.max()) : Integer.valueOf(min + 3);
        }
        if (context.getProperty().getAnnotation(NotEmpty.class).isPresent()) {
            min = min != null ? Integer.valueOf(Math.max(1, min)) : Integer.valueOf(1);
        }
        if (min == null) {
            min = 0;
        }
        if (max == null) {
            max = min + 3;
        }
        return new ArbitraryContainerInfo(min.intValue(), max.intValue());
    }

    static {
        HashSet<Class> set = new HashSet<Class>();
        set.add(Size.class);
        set.add(NotEmpty.class);
        JAKARTA_VALIDATION_CONTAINER_ANNOTATIONS = Collections.unmodifiableSet(set);
    }
}

