/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jakarta.validation.introspector;

import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaContainerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDateTimeConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDecimalConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaIntegerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaStringConstraint;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.MAINTAINED)
public final class JakartaValidationConstraintGenerator
implements JavaConstraintGenerator {
    @Nullable
    public JavaStringConstraint generateStringConstraint(ArbitraryGeneratorContext context) {
        Optional digitsAnnotation;
        Optional size;
        BigInteger min = null;
        BigInteger max = null;
        boolean digits = false;
        boolean notNull = context.findAnnotation(NotNull.class).isPresent();
        boolean notBlank = context.findAnnotation(NotBlank.class).isPresent();
        boolean email = context.findAnnotation(Email.class).isPresent();
        if (notBlank || context.findAnnotation(NotEmpty.class).isPresent()) {
            min = BigInteger.ONE;
        }
        if ((size = context.findAnnotation(Size.class)).isPresent()) {
            int minValue = size.map(Size::min).get();
            if (min == null) {
                min = BigInteger.valueOf(minValue);
            } else if (minValue > 1) {
                min = BigInteger.valueOf(minValue);
            }
            max = BigInteger.valueOf(size.map(Size::max).get().intValue());
        }
        if ((digitsAnnotation = context.findAnnotation(Digits.class)).isPresent()) {
            digits = true;
            notBlank = true;
            BigInteger maxValue = digitsAnnotation.map(Digits::integer).map(BigInteger::valueOf).get();
            if (max == null) {
                max = maxValue;
            } else if (max.compareTo(maxValue) > 0) {
                max = maxValue;
            }
        }
        Optional patternAnnotation = context.findAnnotation(Pattern.class);
        JavaStringConstraint.PatternConstraint patternConstraint = null;
        if (patternAnnotation.isPresent()) {
            String regexp = ((Pattern)patternAnnotation.get()).regexp();
            int[] flags = Arrays.stream(((Pattern)patternAnnotation.get()).flags()).mapToInt(Pattern.Flag::getValue).toArray();
            patternConstraint = new JavaStringConstraint.PatternConstraint(regexp, flags);
        }
        if (!(min != null || max != null || digits || notNull || notBlank || patternConstraint != null || email)) {
            return null;
        }
        return new JavaStringConstraint(min, max, digits, notNull, notBlank, patternConstraint, email);
    }

    @Nullable
    public JavaIntegerConstraint generateIntegerConstraint(ArbitraryGeneratorContext context) {
        Optional decimalMaxAnnotation;
        Optional maxAnnotation;
        Optional decimalMinAnnotation;
        Optional minAnnotation;
        BigInteger positiveMin = null;
        BigInteger positiveMax = null;
        BigInteger negativeMax = null;
        BigInteger negativeMin = null;
        Optional digits = context.findAnnotation(Digits.class);
        if (digits.isPresent()) {
            BigInteger value = BigInteger.ONE;
            int integer = ((Digits)digits.get()).integer();
            if (integer > 1) {
                value = BigInteger.TEN.pow(integer - 1);
            }
            positiveMax = value.multiply(BigInteger.TEN).subtract(BigInteger.ONE);
            positiveMin = value;
            negativeMax = positiveMin.negate();
            negativeMin = positiveMax.negate();
        }
        if ((minAnnotation = context.findAnnotation(Min.class)).isPresent()) {
            BigInteger minValue = minAnnotation.map(Min::value).map(BigInteger::valueOf).get();
            if (minValue.compareTo(BigInteger.ZERO) > 0) {
                positiveMin = positiveMin == null ? minValue : positiveMin.min(minValue);
            } else {
                negativeMin = negativeMin == null ? minValue : negativeMin.min(minValue);
            }
        }
        if ((decimalMinAnnotation = context.findAnnotation(DecimalMin.class)).isPresent()) {
            BigInteger decimalMin = new BigInteger(((DecimalMin)decimalMinAnnotation.get()).value());
            if (!decimalMinAnnotation.map(DecimalMin::inclusive).get().booleanValue()) {
                decimalMin = decimalMin.add(BigInteger.ONE);
            }
            if (decimalMin.compareTo(BigInteger.ZERO) > 0) {
                positiveMin = positiveMin == null ? decimalMin : positiveMin.min(decimalMin);
            } else {
                negativeMin = negativeMin == null ? decimalMin : negativeMin.min(decimalMin);
            }
        }
        if ((maxAnnotation = context.findAnnotation(Max.class)).isPresent()) {
            BigInteger maxValue = maxAnnotation.map(Max::value).map(BigInteger::valueOf).get();
            if (maxValue.compareTo(BigInteger.ZERO) > 0) {
                positiveMax = positiveMax == null ? maxValue : positiveMax.max(maxValue);
            } else {
                negativeMax = negativeMax == null ? maxValue : negativeMax.max(maxValue);
            }
        }
        if ((decimalMaxAnnotation = context.findAnnotation(DecimalMax.class)).isPresent()) {
            BigInteger decimalMax = new BigInteger(((DecimalMax)decimalMaxAnnotation.get()).value());
            if (!decimalMaxAnnotation.map(DecimalMax::inclusive).get().booleanValue()) {
                decimalMax = decimalMax.subtract(BigInteger.ONE);
            }
            if (decimalMax.compareTo(BigInteger.ZERO) > 0) {
                positiveMax = positiveMax == null ? decimalMax : positiveMax.max(decimalMax);
            } else {
                negativeMax = negativeMax == null ? decimalMax : negativeMax.max(decimalMax);
            }
        }
        if (context.findAnnotation(Negative.class).isPresent() && (negativeMax == null || negativeMax.compareTo(BigInteger.ZERO) > 0)) {
            negativeMax = BigInteger.valueOf(-1L);
        }
        if (context.findAnnotation(NegativeOrZero.class).isPresent() && (negativeMax == null || negativeMax.compareTo(BigInteger.ZERO) > 0)) {
            negativeMax = BigInteger.ZERO;
        }
        if (context.findAnnotation(Positive.class).isPresent() && (positiveMin == null || positiveMin.compareTo(BigInteger.ZERO) < 0)) {
            positiveMin = BigInteger.ONE;
        }
        if (context.findAnnotation(PositiveOrZero.class).isPresent() && (positiveMin == null || positiveMin.compareTo(BigInteger.ZERO) < 0)) {
            positiveMin = BigInteger.ZERO;
        }
        Type type = context.getResolvedType();
        if (negativeMin != null) {
            if ((type == Long.class || type == Long.TYPE) && negativeMin.compareTo(BIG_INTEGER_MIN_LONG) < 0) {
                negativeMin = BIG_INTEGER_MIN_LONG;
            }
            if ((type == Integer.class || type == Integer.TYPE) && negativeMin.compareTo(BIG_INTEGER_MIN_INT) < 0) {
                negativeMin = BIG_INTEGER_MIN_INT;
            }
            if ((type == Short.class || type == Short.TYPE) && negativeMin.compareTo(BIG_INTEGER_MIN_SHORT) < 0) {
                negativeMin = BIG_INTEGER_MIN_SHORT;
            }
            if ((type == Byte.class || type == Byte.TYPE) && negativeMin.compareTo(BIG_INTEGER_MIN_BYTE) < 0) {
                negativeMin = BIG_INTEGER_MIN_BYTE;
            }
        }
        if (positiveMax != null) {
            if ((type == Long.class || type == Long.TYPE) && positiveMax.compareTo(BIG_INTEGER_MAX_LONG) > 0) {
                positiveMax = BIG_INTEGER_MAX_LONG;
            }
            if ((type == Integer.class || type == Integer.TYPE) && positiveMax.compareTo(BIG_INTEGER_MAX_INT) > 0) {
                positiveMax = BIG_INTEGER_MAX_INT;
            }
            if ((type == Short.class || type == Short.TYPE) && positiveMax.compareTo(BIG_INTEGER_MAX_SHORT) > 0) {
                positiveMax = BIG_INTEGER_MAX_SHORT;
            }
            if ((type == Byte.class || type == Byte.TYPE) && positiveMax.compareTo(BIG_INTEGER_MAX_BYTE) > 0) {
                positiveMax = BIG_INTEGER_MAX_BYTE;
            }
        }
        if (positiveMin == null && positiveMax == null && negativeMin == null && negativeMax == null) {
            return null;
        }
        return new JavaIntegerConstraint(positiveMin, positiveMax, negativeMin, negativeMax);
    }

    @Nullable
    public JavaDecimalConstraint generateDecimalConstraint(ArbitraryGeneratorContext context) {
        Optional decimalMaxAnnotation;
        Optional maxAnnotation;
        Optional decimalMinAnnotation;
        Optional minAnnotation;
        BigDecimal positiveMin = null;
        Boolean positiveMinInclusive = null;
        BigDecimal positiveMax = null;
        Boolean positiveMaxInclusive = null;
        BigDecimal negativeMin = null;
        Boolean negativeMinInclusive = null;
        BigDecimal negativeMax = null;
        boolean negativeMaxInclusive = false;
        Integer scale = null;
        Optional digits = context.findAnnotation(Digits.class);
        if (digits.isPresent()) {
            BigDecimal value = BigDecimal.ONE;
            int integer = ((Digits)digits.get()).integer();
            if (integer > 1) {
                value = BigDecimal.TEN.pow(integer - 1);
            }
            positiveMax = value.multiply(BigDecimal.TEN).subtract(BigDecimal.ONE);
            positiveMin = value;
            negativeMax = positiveMin.negate();
            negativeMin = positiveMax.negate();
            positiveMinInclusive = false;
            negativeMinInclusive = false;
            scale = ((Digits)digits.get()).fraction();
        }
        if ((minAnnotation = context.findAnnotation(Min.class)).isPresent()) {
            BigDecimal minValue = minAnnotation.map(Min::value).map(BigDecimal::valueOf).get();
            if (minValue.compareTo(BigDecimal.ZERO) > 0) {
                positiveMin = positiveMin == null ? minValue : positiveMin.min(minValue);
                negativeMax = null;
                negativeMin = null;
            } else {
                negativeMin = negativeMin == null ? minValue : negativeMin.min(minValue);
                negativeMinInclusive = true;
            }
        }
        if ((decimalMinAnnotation = context.findAnnotation(DecimalMin.class)).isPresent()) {
            BigDecimal decimalMin = new BigDecimal(((DecimalMin)decimalMinAnnotation.get()).value());
            if (decimalMin.compareTo(BigDecimal.ZERO) > 0) {
                positiveMin = positiveMin == null ? decimalMin : positiveMin.min(decimalMin);
                if (!decimalMinAnnotation.map(DecimalMin::inclusive).get().booleanValue()) {
                    positiveMinInclusive = false;
                }
                negativeMax = null;
                negativeMin = null;
            } else {
                negativeMin = negativeMin == null ? decimalMin : negativeMin.min(negativeMin);
                if (!decimalMinAnnotation.map(DecimalMin::inclusive).get().booleanValue()) {
                    negativeMinInclusive = false;
                }
            }
        }
        if ((maxAnnotation = context.findAnnotation(Max.class)).isPresent()) {
            BigDecimal maxValue = maxAnnotation.map(Max::value).map(BigDecimal::valueOf).get();
            if (maxValue.compareTo(BigDecimal.ZERO) > 0) {
                positiveMax = positiveMax == null ? maxValue : positiveMax.max(maxValue);
            } else {
                negativeMax = negativeMax == null ? maxValue : negativeMax.max(maxValue);
            }
        }
        if ((decimalMaxAnnotation = context.findAnnotation(DecimalMax.class)).isPresent()) {
            BigDecimal decimalMax = new BigDecimal(((DecimalMax)decimalMaxAnnotation.get()).value());
            if (decimalMax.compareTo(BigDecimal.ZERO) > 0) {
                positiveMax = positiveMax == null ? decimalMax : positiveMax.max(decimalMax);
                positiveMaxInclusive = decimalMaxAnnotation.map(DecimalMax::inclusive).get();
            } else {
                negativeMax = negativeMax == null ? decimalMax : negativeMax.max(decimalMax);
                negativeMaxInclusive = decimalMaxAnnotation.map(DecimalMax::inclusive).get();
            }
            if (!decimalMaxAnnotation.map(DecimalMax::inclusive).get().booleanValue()) {
                positiveMaxInclusive = false;
            }
            if (positiveMax == null) {
                positiveMax = decimalMax;
            } else if (positiveMax.compareTo(decimalMax) > 0) {
                positiveMax = decimalMax;
            }
        }
        if (context.findAnnotation(Negative.class).isPresent() && (negativeMax == null || negativeMax.compareTo(BigDecimal.ZERO) > 0)) {
            negativeMax = BigDecimal.ZERO;
            negativeMaxInclusive = false;
        }
        if (context.findAnnotation(NegativeOrZero.class).isPresent() && (negativeMax == null || negativeMax.compareTo(BigDecimal.ZERO) > 0)) {
            negativeMax = BigDecimal.ZERO;
            negativeMaxInclusive = true;
        }
        if (context.findAnnotation(Positive.class).isPresent() && (positiveMin == null || positiveMin.compareTo(BigDecimal.ZERO) < 0)) {
            positiveMin = BigDecimal.ZERO;
            positiveMinInclusive = false;
        }
        if (context.findAnnotation(PositiveOrZero.class).isPresent() && (positiveMin == null || positiveMin.compareTo(BigDecimal.ZERO) < 0)) {
            positiveMin = BigDecimal.ZERO;
            positiveMinInclusive = true;
        }
        if (positiveMin == null && positiveMax == null && negativeMin == null && negativeMax == null && scale == null) {
            return null;
        }
        return new JavaDecimalConstraint(positiveMin, positiveMinInclusive, positiveMax, positiveMaxInclusive, negativeMin, negativeMinInclusive, negativeMax, Boolean.valueOf(negativeMaxInclusive), scale);
    }

    @Nullable
    public JavaContainerConstraint generateContainerConstraint(ArbitraryGeneratorContext context) {
        Integer minSize = null;
        Integer maxSize = null;
        boolean notEmpty = context.findAnnotation(NotEmpty.class).isPresent();
        Optional sizeAnnotation = context.findAnnotation(Size.class);
        if (sizeAnnotation.isPresent()) {
            Size size = (Size)sizeAnnotation.get();
            minSize = size.min();
            maxSize = size.max();
        }
        if (minSize == null && maxSize == null && !notEmpty) {
            return null;
        }
        return new JavaContainerConstraint(minSize, maxSize, notEmpty);
    }

    @Nullable
    public JavaDateTimeConstraint generateDateTimeConstraint(ArbitraryGeneratorContext context) {
        Supplier<LocalDateTime> min = null;
        if (context.findAnnotation(Future.class).isPresent()) {
            min = () -> LocalDateTime.now().plusSeconds(3L);
        } else if (context.findAnnotation(FutureOrPresent.class).isPresent()) {
            min = () -> LocalDateTime.now().plusSeconds(2L);
        }
        Supplier<LocalDateTime> max = null;
        if (context.findAnnotation(Past.class).isPresent()) {
            max = () -> LocalDateTime.now().minusSeconds(1L);
        } else if (context.findAnnotation(PastOrPresent.class).isPresent()) {
            max = LocalDateTime::now;
        }
        if (min == null && max == null) {
            return null;
        }
        return new JavaDateTimeConstraint(min, max);
    }
}

