/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jakarta.validation.validator;

import com.navercorp.fixturemonkey.api.exception.ValidationFailedException;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.5.6", status=API.Status.MAINTAINED)
public final class JakartaArbitraryValidator
implements ArbitraryValidator {
    private Validator validator;

    public JakartaArbitraryValidator() {
        try {
            this.validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        catch (Exception e) {
            this.validator = null;
        }
    }

    public void validate(Object arbitrary) {
        if (this.validator != null) {
            Set violations = this.validator.validate(arbitrary, new Class[0]);
            Set constraintViolationPropertyNames = violations.stream().map(ConstraintViolation::getPropertyPath).map(Path::toString).collect(Collectors.toSet());
            if (!violations.isEmpty()) {
                throw new ValidationFailedException("DefaultArbitrayValidator ConstraintViolations. type: " + arbitrary.getClass(), constraintViolationPropertyNames);
            }
        }
    }
}

