/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jakarta.validation.generator;

import com.navercorp.fixturemonkey.api.generator.DefaultNullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.type.Types;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.MAINTAINED)
public final class JakartaValidationNullInjectGenerator
implements NullInjectGenerator {
    private final NullInjectGenerator delegate;

    public JakartaValidationNullInjectGenerator() {
        this((NullInjectGenerator)new DefaultNullInjectGenerator());
    }

    public JakartaValidationNullInjectGenerator(NullInjectGenerator delegate) {
        this.delegate = delegate;
    }

    public double generate(ObjectPropertyGeneratorContext context) {
        Set annotations = context.getProperty().getAnnotations().stream().map(Annotation::annotationType).collect(Collectors.toSet());
        if (annotations.contains(Null.class)) {
            return 1.0;
        }
        double nullInject = this.delegate.generate(context);
        if (nullInject == 0.0) {
            return nullInject;
        }
        if (annotations.contains(NotNull.class)) {
            return 0.0;
        }
        if (Types.getActualType((Type)context.getProperty().getType()) == String.class && (annotations.contains(NotBlank.class) || annotations.contains(NotEmpty.class))) {
            return 0.0;
        }
        if (context.isContainer() && annotations.contains(NotEmpty.class)) {
            return 0.0;
        }
        return nullInject;
    }
}

