/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.jakarta.validation.introspector;

import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaContainerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDateTimeConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDecimalConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaIntegerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaStringConstraint;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.MAINTAINED)
public final class JakartaValidationConstraintGenerator
implements JavaConstraintGenerator {
    @Nullable
    public JavaStringConstraint generateStringConstraint(ArbitraryGeneratorContext context) {
        Optional digitsAnnotation;
        Optional size;
        BigInteger min = null;
        BigInteger max = null;
        boolean digits = false;
        boolean notNull = context.findAnnotation(NotNull.class).isPresent();
        boolean notBlank = context.findAnnotation(NotBlank.class).isPresent();
        boolean email = context.findAnnotation(Email.class).isPresent();
        if (notBlank || context.findAnnotation(NotEmpty.class).isPresent()) {
            min = BigInteger.ONE;
        }
        if ((size = context.findAnnotation(Size.class)).isPresent()) {
            int minValue = size.map(Size::min).get();
            if (min == null) {
                min = BigInteger.valueOf(minValue);
            } else if (minValue > 1) {
                min = BigInteger.valueOf(minValue);
            }
            max = BigInteger.valueOf(size.map(Size::max).get().intValue());
        }
        if ((digitsAnnotation = context.findAnnotation(Digits.class)).isPresent()) {
            digits = true;
            notBlank = true;
            BigInteger maxValue = digitsAnnotation.map(Digits::integer).map(BigInteger::valueOf).get();
            if (max == null) {
                max = maxValue;
            } else if (max.compareTo(maxValue) > 0) {
                max = maxValue;
            }
        }
        Optional patternAnnotation = context.findAnnotation(Pattern.class);
        JavaStringConstraint.PatternConstraint patternConstraint = null;
        if (patternAnnotation.isPresent()) {
            String regexp = ((Pattern)patternAnnotation.get()).regexp();
            int[] flags = Arrays.stream(((Pattern)patternAnnotation.get()).flags()).mapToInt(Pattern.Flag::getValue).toArray();
            patternConstraint = new JavaStringConstraint.PatternConstraint(regexp, flags);
        }
        if (!(min != null || max != null || digits || notNull || notBlank || patternConstraint != null || email)) {
            return null;
        }
        return new JavaStringConstraint(min, max, digits, notNull, notBlank, patternConstraint, email);
    }

    @Nullable
    public JavaIntegerConstraint generateIntegerConstraint(ArbitraryGeneratorContext context) {
        Optional digitsAnnotation;
        Optional decimalMaxAnnotation;
        Optional maxAnnotation;
        Optional decimalMinAnnotation;
        BigInteger min = null;
        BigInteger max = null;
        Optional minAnnotation = context.findAnnotation(Min.class);
        if (minAnnotation.isPresent()) {
            min = BigInteger.valueOf(((Min)minAnnotation.get()).value());
        }
        if ((decimalMinAnnotation = context.findAnnotation(DecimalMin.class)).isPresent()) {
            BigInteger decimalMin = new BigInteger(((DecimalMin)decimalMinAnnotation.get()).value());
            if (!decimalMinAnnotation.map(DecimalMin::inclusive).get().booleanValue()) {
                decimalMin = decimalMin.add(BigInteger.ONE);
            }
            if (min == null || decimalMin.compareTo(min) > 0) {
                min = decimalMin;
            }
        }
        if ((maxAnnotation = context.findAnnotation(Max.class)).isPresent()) {
            max = BigInteger.valueOf(((Max)maxAnnotation.get()).value());
        }
        if ((decimalMaxAnnotation = context.findAnnotation(DecimalMax.class)).isPresent()) {
            BigInteger decimalMax = new BigInteger(((DecimalMax)decimalMaxAnnotation.get()).value());
            if (!decimalMaxAnnotation.map(DecimalMax::inclusive).get().booleanValue()) {
                decimalMax = decimalMax.subtract(BigInteger.ONE);
            }
            if (max == null || decimalMax.compareTo(max) < 0) {
                max = decimalMax;
            }
        }
        if (context.findAnnotation(Positive.class).isPresent()) {
            BigInteger positiveMin = BigInteger.ONE;
            if (min == null || positiveMin.compareTo(min) > 0) {
                min = positiveMin;
            }
        }
        if (context.findAnnotation(PositiveOrZero.class).isPresent()) {
            BigInteger positiveOrZeroMin = BigInteger.ZERO;
            if (min == null || positiveOrZeroMin.compareTo(min) > 0) {
                min = positiveOrZeroMin;
            }
        }
        if (context.findAnnotation(Negative.class).isPresent()) {
            BigInteger negativeMax = BigInteger.valueOf(-1L);
            if (max == null || negativeMax.compareTo(max) < 0) {
                max = negativeMax;
            }
        }
        if (context.findAnnotation(NegativeOrZero.class).isPresent()) {
            BigInteger negativeOrZeroMax = BigInteger.ZERO;
            if (max == null || negativeOrZeroMax.compareTo(max) < 0) {
                max = negativeOrZeroMax;
            }
        }
        if ((digitsAnnotation = context.findAnnotation(Digits.class)).isPresent()) {
            Digits digits = (Digits)digitsAnnotation.get();
            int integerDigits = digits.integer();
            BigInteger digitsMax = BigInteger.TEN.pow(integerDigits).subtract(BigInteger.ONE);
            BigInteger digitsMin = digitsMax.negate();
            if (max == null || digitsMax.compareTo(max) < 0) {
                max = digitsMax;
            }
            if (min == null || digitsMin.compareTo(min) > 0) {
                min = digitsMin;
            }
        }
        Type type = context.getResolvedType();
        if (min != null) {
            if ((type == Long.class || type == Long.TYPE) && min.compareTo(BIG_INTEGER_MIN_LONG) < 0) {
                min = BIG_INTEGER_MIN_LONG;
            }
            if ((type == Integer.class || type == Integer.TYPE) && min.compareTo(BIG_INTEGER_MIN_INT) < 0) {
                min = BIG_INTEGER_MIN_INT;
            }
            if ((type == Short.class || type == Short.TYPE) && min.compareTo(BIG_INTEGER_MIN_SHORT) < 0) {
                min = BIG_INTEGER_MIN_SHORT;
            }
            if ((type == Byte.class || type == Byte.TYPE) && min.compareTo(BIG_INTEGER_MIN_BYTE) < 0) {
                min = BIG_INTEGER_MIN_BYTE;
            }
        }
        if (max != null) {
            if ((type == Long.class || type == Long.TYPE) && max.compareTo(BIG_INTEGER_MAX_LONG) > 0) {
                max = BIG_INTEGER_MAX_LONG;
            }
            if ((type == Integer.class || type == Integer.TYPE) && max.compareTo(BIG_INTEGER_MAX_INT) > 0) {
                max = BIG_INTEGER_MAX_INT;
            }
            if ((type == Short.class || type == Short.TYPE) && max.compareTo(BIG_INTEGER_MAX_SHORT) > 0) {
                max = BIG_INTEGER_MAX_SHORT;
            }
            if ((type == Byte.class || type == Byte.TYPE) && max.compareTo(BIG_INTEGER_MAX_BYTE) > 0) {
                max = BIG_INTEGER_MAX_BYTE;
            }
        }
        if (min == null && max == null) {
            return null;
        }
        return new JavaIntegerConstraint(min, max);
    }

    @Nullable
    public JavaDecimalConstraint generateDecimalConstraint(ArbitraryGeneratorContext context) {
        Optional digitsAnn;
        Optional decimalMaxAnnotation;
        Optional maxAnnotation;
        Optional decimalMinAnnotation;
        BigDecimal min = null;
        Boolean minInclusive = null;
        BigDecimal max = null;
        Boolean maxInclusive = null;
        Integer scale = null;
        Optional minAnnotation = context.findAnnotation(Min.class);
        if (minAnnotation.isPresent()) {
            min = BigDecimal.valueOf(((Min)minAnnotation.get()).value());
            minInclusive = true;
        }
        if ((decimalMinAnnotation = context.findAnnotation(DecimalMin.class)).isPresent()) {
            BigDecimal newMin = new BigDecimal(((DecimalMin)decimalMinAnnotation.get()).value());
            if (min == null || newMin.compareTo(min) > 0 || newMin.compareTo(min) == 0 && !((DecimalMin)decimalMinAnnotation.get()).inclusive()) {
                min = newMin;
                minInclusive = ((DecimalMin)decimalMinAnnotation.get()).inclusive();
            }
        }
        if ((maxAnnotation = context.findAnnotation(Max.class)).isPresent()) {
            max = BigDecimal.valueOf(((Max)maxAnnotation.get()).value());
            maxInclusive = true;
        }
        if ((decimalMaxAnnotation = context.findAnnotation(DecimalMax.class)).isPresent()) {
            BigDecimal newMax = new BigDecimal(((DecimalMax)decimalMaxAnnotation.get()).value());
            if (max == null || newMax.compareTo(max) < 0 || newMax.compareTo(max) == 0 && !((DecimalMax)decimalMaxAnnotation.get()).inclusive()) {
                max = newMax;
                maxInclusive = ((DecimalMax)decimalMaxAnnotation.get()).inclusive();
            }
        }
        if (context.findAnnotation(Positive.class).isPresent() && (min == null || BigDecimal.ZERO.compareTo(min) > 0 || BigDecimal.ZERO.compareTo(min) == 0 && minInclusive.booleanValue())) {
            min = BigDecimal.ZERO;
            minInclusive = false;
        }
        if (context.findAnnotation(PositiveOrZero.class).isPresent() && (min == null || BigDecimal.ZERO.compareTo(min) > 0)) {
            min = BigDecimal.ZERO;
            minInclusive = true;
        }
        if (context.findAnnotation(Negative.class).isPresent() && (max == null || BigDecimal.ZERO.compareTo(max) < 0 || BigDecimal.ZERO.compareTo(max) == 0 && maxInclusive.booleanValue())) {
            max = BigDecimal.ZERO;
            maxInclusive = false;
        }
        if (context.findAnnotation(NegativeOrZero.class).isPresent() && (max == null || BigDecimal.ZERO.compareTo(max) < 0)) {
            max = BigDecimal.ZERO;
            maxInclusive = true;
        }
        if ((digitsAnn = context.findAnnotation(Digits.class)).isPresent()) {
            int i;
            Digits digits = (Digits)digitsAnn.get();
            int integerDigits = digits.integer();
            int fractionDigits = digits.fraction();
            StringBuilder maxBuilder = new StringBuilder();
            for (i = 0; i < integerDigits; ++i) {
                maxBuilder.append('9');
            }
            if (fractionDigits > 0) {
                maxBuilder.append('.');
                for (i = 0; i < fractionDigits; ++i) {
                    maxBuilder.append('9');
                }
            }
            BigDecimal digitsMax = new BigDecimal(maxBuilder.toString());
            BigDecimal digitsMin = digitsMax.negate();
            if (max == null || digitsMax.compareTo(max) < 0) {
                max = digitsMax;
                maxInclusive = true;
            }
            if (min == null || digitsMin.compareTo(min) > 0) {
                min = digitsMin;
                minInclusive = true;
            }
            scale = digits.fraction();
        }
        if (min == null && max == null) {
            return null;
        }
        return new JavaDecimalConstraint(min, minInclusive, max, maxInclusive, scale);
    }

    @Nullable
    public JavaContainerConstraint generateContainerConstraint(ArbitraryGeneratorContext context) {
        Integer minSize = null;
        Integer maxSize = null;
        boolean notEmpty = context.findAnnotation(NotEmpty.class).isPresent();
        Optional sizeAnnotation = context.findAnnotation(Size.class);
        if (sizeAnnotation.isPresent()) {
            Size size = (Size)sizeAnnotation.get();
            minSize = size.min();
            maxSize = size.max();
        }
        if (minSize == null && maxSize == null && !notEmpty) {
            return null;
        }
        return new JavaContainerConstraint(minSize, maxSize, notEmpty);
    }

    @Nullable
    public JavaDateTimeConstraint generateDateTimeConstraint(ArbitraryGeneratorContext context) {
        Supplier<LocalDateTime> min = null;
        if (context.findAnnotation(Future.class).isPresent()) {
            min = () -> LocalDateTime.now().plusSeconds(3L);
        } else if (context.findAnnotation(FutureOrPresent.class).isPresent()) {
            min = () -> LocalDateTime.now().plusSeconds(2L);
        }
        Supplier<LocalDateTime> max = null;
        if (context.findAnnotation(Past.class).isPresent()) {
            max = () -> LocalDateTime.now().minusSeconds(1L);
        } else if (context.findAnnotation(PastOrPresent.class).isPresent()) {
            max = LocalDateTime::now;
        }
        if (min == null && max == null) {
            return null;
        }
        return new JavaDateTimeConstraint(min, max);
    }
}

