/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import com.navercorp.fixturemonkey.ArbitraryOption;
import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNullity;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetPostCondition;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySpecAny;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryTraverser;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryTree;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.BuilderManipulator;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeConstraint;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeManipulator;
import com.navercorp.fixturemonkey.arbitrary.MetadataManipulator;
import com.navercorp.fixturemonkey.arbitrary.PostArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizer;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.customizer.ExpressionSpec;
import com.navercorp.fixturemonkey.customizer.WithFixtureCustomizer;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import com.navercorp.fixturemonkey.validator.ArbitraryValidator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;

public final class ArbitraryBuilder<T> {
    private final ArbitraryTree<T> tree;
    private final ArbitraryTraverser traverser;
    private final List<BuilderManipulator> builderManipulators;
    private final List<BuilderManipulator> usedManipulators;
    private final ArbitraryValidator validator;
    private final Map<Class<?>, ArbitraryGenerator> generatorMap;
    private final List<BiConsumer<T, ArbitraryBuilder<T>>> decomposedManipulators;
    private ArbitraryGenerator generator;
    private ArbitraryCustomizers arbitraryCustomizers;
    private boolean validOnly = true;

    ArbitraryBuilder(Class<T> clazz, ArbitraryOption options, ArbitraryGenerator generator, ArbitraryValidator validator, ArbitraryCustomizers arbitraryCustomizers, Map<Class<?>, ArbitraryGenerator> generatorMap) {
        this(new ArbitraryTree<T>(ArbitraryNode.builder().type(new ArbitraryType<T>(clazz)).fieldName("HEAD_NAME").build()), new ArbitraryTraverser(options), generator, validator, arbitraryCustomizers, new ArrayList<BuilderManipulator>(), new ArrayList<BuilderManipulator>(), new ArrayList<BiConsumer<T, ArbitraryBuilder<T>>>(), generatorMap);
    }

    ArbitraryBuilder(Supplier<T> valueSupplier, ArbitraryTraverser traverser, ArbitraryGenerator generator, ArbitraryValidator validator, ArbitraryCustomizers arbitraryCustomizers, Map<Class<?>, ArbitraryGenerator> generatorMap) {
        this(new ArbitraryTree<Supplier<T>>(ArbitraryNode.builder().value(valueSupplier).fieldName("HEAD_NAME").build()), traverser, generator, validator, arbitraryCustomizers, new ArrayList<BuilderManipulator>(), new ArrayList<BuilderManipulator>(), new ArrayList<BiConsumer<T, ArbitraryBuilder<T>>>(), generatorMap);
    }

    private ArbitraryBuilder(ArbitraryTree<T> tree, ArbitraryTraverser traverser, ArbitraryGenerator generator, ArbitraryValidator validator, ArbitraryCustomizers arbitraryCustomizers, List<BuilderManipulator> builderManipulators, List<BuilderManipulator> usedManipulators, List<BiConsumer<T, ArbitraryBuilder<T>>> decomposedManipulators, Map<Class<?>, ArbitraryGenerator> generatorMap) {
        this.tree = tree;
        this.traverser = traverser;
        this.generator = this.getGenerator(generator, arbitraryCustomizers);
        this.validator = validator;
        this.arbitraryCustomizers = arbitraryCustomizers;
        this.builderManipulators = new ArrayList<BuilderManipulator>(builderManipulators);
        this.usedManipulators = new ArrayList<BuilderManipulator>(usedManipulators);
        this.decomposedManipulators = decomposedManipulators;
        this.generatorMap = generatorMap.entrySet().stream().map((? super T it) -> new AbstractMap.SimpleEntry<Class, ArbitraryGenerator>((Class)it.getKey(), this.getGenerator((ArbitraryGenerator)it.getValue(), arbitraryCustomizers))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public ArbitraryBuilder<T> validOnly(boolean validOnly) {
        this.validOnly = validOnly;
        return this;
    }

    public ArbitraryBuilder<T> generator(ArbitraryGenerator generator) {
        this.generator = this.getGenerator(generator, this.arbitraryCustomizers);
        return this;
    }

    public Arbitrary<T> build() {
        ArbitraryBuilder<T> buildArbitraryBuilder = this.copy();
        return buildArbitraryBuilder.tree.result(() -> {
            ArbitraryTree<T> buildTree = buildArbitraryBuilder.tree;
            buildArbitraryBuilder.traverser.traverse(buildTree, false, (FieldNameResolver)buildArbitraryBuilder.generator);
            List<BuilderManipulator> actualManipulators = buildArbitraryBuilder.getActiveManipulators();
            buildArbitraryBuilder.apply(actualManipulators);
            buildTree.update(buildArbitraryBuilder.generator, this.generatorMap);
            return buildTree.getArbitrary();
        }, this.validator, this.validOnly);
    }

    public T sample() {
        return (T)this.build().sample();
    }

    private T sampleInternal() {
        return (T)this.tree.result(() -> {
            ArbitraryTree<T> buildTree = this.tree;
            this.traverser.traverse(buildTree, false, (FieldNameResolver)this.generator);
            this.apply(this.getActiveManipulators());
            this.builderManipulators.clear();
            buildTree.update(this.generator, this.generatorMap);
            return buildTree.getArbitrary();
        }, this.validator, this.validOnly).sample();
    }

    public List<T> sampleList(int size) {
        return this.sampleStream().limit(size).collect(Collectors.toList());
    }

    public Stream<T> sampleStream() {
        return this.build().sampleStream();
    }

    public ArbitraryBuilder<T> spec(ExpressionSpec expressionSpec) {
        this.builderManipulators.addAll(expressionSpec.getBuilderManipulators());
        return this;
    }

    public ArbitraryBuilder<T> specAny(ExpressionSpec ... expressionSpecs) {
        this.builderManipulators.add(new ArbitrarySpecAny(Arrays.asList(expressionSpecs)));
        return this;
    }

    public ArbitraryBuilder<T> set(String expression, @Nullable Object value) {
        if (value == null) {
            return this.setNull(expression);
        }
        if (value instanceof Arbitrary) {
            return this.set(expression, (Arbitrary)value);
        }
        if (value instanceof ArbitraryBuilder) {
            return this.setBuilder(expression, (ArbitraryBuilder)value);
        }
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySet<Object>(arbitraryExpression, value));
        return this;
    }

    public ArbitraryBuilder<T> set(String expression, Object value, long limit) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySet<Object>(arbitraryExpression, value, limit));
        return this;
    }

    public ArbitraryBuilder<T> set(String expression, @Nullable Arbitrary<?> value) {
        if (value == null) {
            return this.setNull(expression);
        }
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySetArbitrary(arbitraryExpression, value));
        return this;
    }

    public ArbitraryBuilder<T> set(@Nullable Object value) {
        return this.set("HEAD_NAME", value);
    }

    public ArbitraryBuilder<T> setBuilder(String expression, ArbitraryBuilder<?> builder) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySetArbitrary(arbitraryExpression, builder.build()));
        return this;
    }

    public ArbitraryBuilder<T> setBuilder(String expression, ArbitraryBuilder<?> builder, long limit) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySetArbitrary(arbitraryExpression, builder.build(), limit));
        return this;
    }

    public ArbitraryBuilder<T> setNull(String expression) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitraryNullity(arbitraryExpression, true));
        return this;
    }

    public ArbitraryBuilder<T> setNotNull(String expression) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitraryNullity(arbitraryExpression, false));
        return this;
    }

    public ArbitraryBuilder<T> setPostCondition(Predicate<T> filter) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from("HEAD_NAME");
        this.builderManipulators.add(new ArbitrarySetPostCondition<T>(this.tree.getClazz(), arbitraryExpression, filter));
        return this;
    }

    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> clazz, Predicate<U> filter) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySetPostCondition<U>(clazz, arbitraryExpression, filter));
        return this;
    }

    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> clazz, Predicate<U> filter, long limit) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ArbitrarySetPostCondition<U>(clazz, arbitraryExpression, filter, limit));
        return this;
    }

    public ArbitraryBuilder<T> size(String expression, int size) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ContainerSizeManipulator(arbitraryExpression, size, size));
        return this;
    }

    public ArbitraryBuilder<T> size(String expression, int min, int max) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ContainerSizeManipulator(arbitraryExpression, min, max));
        return this;
    }

    public ArbitraryBuilder<T> minSize(String expression, int min) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ContainerSizeManipulator(arbitraryExpression, min, null));
        return this;
    }

    public ArbitraryBuilder<T> maxSize(String expression, int max) {
        ArbitraryExpression arbitraryExpression = ArbitraryExpression.from(expression);
        this.builderManipulators.add(new ContainerSizeManipulator(arbitraryExpression, null, max));
        return this;
    }

    public ArbitraryBuilder<T> customize(Class<T> type, ArbitraryCustomizer<T> customizer) {
        this.arbitraryCustomizers = this.arbitraryCustomizers.mergeWith(Collections.singletonMap(type, customizer));
        if (this.generator instanceof WithFixtureCustomizer) {
            this.generator = ((WithFixtureCustomizer)((Object)this.generator)).withFixtureCustomizers(this.arbitraryCustomizers);
        }
        return this;
    }

    public <U> ArbitraryBuilder<U> map(Function<T, U> mapper) {
        return new ArbitraryBuilder<Object>(() -> mapper.apply(this.sample()), this.traverser, this.generator, this.validator, this.arbitraryCustomizers, this.generatorMap);
    }

    public <U, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, BiFunction<T, U, R> combinator) {
        return new ArbitraryBuilder<Object>(() -> combinator.apply(this.sample(), other.sample()), this.traverser, this.generator, this.validator, this.arbitraryCustomizers, this.generatorMap);
    }

    public <U, V, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, Combinators.F3<T, U, V, R> combinator) {
        return new ArbitraryBuilder<Object>(() -> combinator.apply(this.sample(), other.sample(), another.sample()), this.traverser, this.generator, this.validator, this.arbitraryCustomizers, this.generatorMap);
    }

    public <U, V, W, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, ArbitraryBuilder<W> theOther, Combinators.F4<T, U, V, W, R> combinator) {
        return new ArbitraryBuilder<Object>(() -> combinator.apply(this.sample(), other.sample(), another.sample(), theOther.sample()), this.traverser, this.generator, this.validator, this.arbitraryCustomizers, this.generatorMap);
    }

    public <U> ArbitraryBuilder<U> zipWith(List<ArbitraryBuilder<?>> others, Function<List<?>, U> combinator) {
        return new ArbitraryBuilder<Object>(() -> {
            ArrayList<T> combinedList = new ArrayList<T>();
            combinedList.add(this.sample());
            for (ArbitraryBuilder other : others) {
                combinedList.add(other.sample());
            }
            return combinator.apply(combinedList);
        }, this.traverser, this.generator, this.validator, this.arbitraryCustomizers, this.generatorMap);
    }

    public ArbitraryBuilder<T> apply(BiConsumer<T, ArbitraryBuilder<T>> biConsumer) {
        ArbitraryBuilder<T> appliedBuilder = this.copy();
        this.decomposedManipulators.add(biConsumer);
        this.setCurrentBuilderManipulatorsAsUsed();
        this.tree.setDecomposedValue(() -> {
            ArbitraryBuilder copied = appliedBuilder.copy();
            Object sample = super.sampleInternal();
            copied.tree.setDecomposedValue(() -> sample);
            this.decomposedManipulators.forEach(it -> it.accept(sample, copied));
            return super.sampleInternal();
        });
        return this;
    }

    public ArbitraryBuilder<T> acceptIf(Predicate<T> predicate, Consumer<ArbitraryBuilder<T>> consumer) {
        return this.apply((T obj, ArbitraryBuilder<T> builder) -> {
            if (predicate.test(obj)) {
                consumer.accept((ArbitraryBuilder)builder);
            }
        });
    }

    public ArbitraryBuilder<T> fixed() {
        ArbitraryBuilder<T> copied = this.copy();
        this.setCurrentBuilderManipulatorsAsUsed();
        this.tree.setFixedDecomposedValue(copied::sampleInternal);
        return this;
    }

    public ArbitraryBuilder<T> apply(MetadataManipulator manipulator) {
        ArbitraryExpression arbitraryExpression = manipulator.getArbitraryExpression();
        if (manipulator instanceof ContainerSizeManipulator) {
            ContainerSizeManipulator containerSizeManipulator = (ContainerSizeManipulator)manipulator;
            Collection<ArbitraryNode> foundNodes = this.findNodesByExpression(arbitraryExpression);
            for (ArbitraryNode foundNode : foundNodes) {
                if (!foundNode.getType().isContainer()) {
                    throw new IllegalArgumentException("Only Container can set size");
                }
                foundNode.setContainerSizeConstraint(new ContainerSizeConstraint(containerSizeManipulator.getMin(), containerSizeManipulator.getMax()));
                this.traverser.traverse(foundNode, false, (FieldNameResolver)this.generator);
            }
        } else {
            throw new IllegalArgumentException("Not Implemented MetadataManipulator");
        }
        return this;
    }

    public void apply(AbstractArbitrarySet<T> fixtureSet) {
        Collection<ArbitraryNode> foundNodes = this.findNodesByExpression(fixtureSet.getArbitraryExpression());
        if (!foundNodes.isEmpty()) {
            for (ArbitraryNode foundNode : foundNodes) {
                foundNode.apply(fixtureSet);
            }
        }
    }

    public ArbitraryBuilder<T> setNullity(ArbitraryNullity arbitraryNullity) {
        ArbitraryExpression arbitraryExpression = arbitraryNullity.getArbitraryExpression();
        Collection<ArbitraryNode> foundNodes = this.findNodesByExpression(arbitraryExpression);
        for (ArbitraryNode foundNode : foundNodes) {
            foundNode.apply(arbitraryNullity);
        }
        return this;
    }

    public ArbitraryBuilder<T> apply(PostArbitraryManipulator<T> postArbitraryManipulator) {
        Collection<ArbitraryNode> foundNodes = this.findNodesByExpression(postArbitraryManipulator.getArbitraryExpression());
        if (!foundNodes.isEmpty()) {
            for (ArbitraryNode foundNode : foundNodes) {
                if (!postArbitraryManipulator.isMappableTo(foundNode)) continue;
                foundNode.addPostArbitraryOperation(postArbitraryManipulator);
            }
        }
        return this;
    }

    public void apply(List<BuilderManipulator> arbitraryManipulators) {
        List<MetadataManipulator> metadataManipulators = this.extractMetadataManipulatorsFrom(arbitraryManipulators);
        List<BuilderManipulator> orderedArbitraryManipulators = this.extractOrderedManipulatorsFrom(arbitraryManipulators);
        List<PostArbitraryManipulator> postArbitraryManipulators = this.extractPostArbitraryManipulatorsFrom(arbitraryManipulators);
        metadataManipulators.stream().sorted().forEachOrdered(it -> it.accept(this));
        orderedArbitraryManipulators.forEach(it -> it.accept(this));
        postArbitraryManipulators.forEach(it -> it.accept(this));
    }

    public boolean isDirty() {
        return this.usedManipulators.size() != this.builderManipulators.size();
    }

    public ArbitraryBuilder<T> copy() {
        ArbitraryBuilder<T> copied = new ArbitraryBuilder<T>(this.tree.copy(), this.traverser, this.generator, this.validator, this.arbitraryCustomizers, this.builderManipulators.stream().map(BuilderManipulator::copy).collect(Collectors.toList()), this.usedManipulators.stream().map(BuilderManipulator::copy).collect(Collectors.toList()), new ArrayList<BiConsumer<T, ArbitraryBuilder<T>>>(this.decomposedManipulators), this.generatorMap);
        copied.validOnly(this.validOnly);
        return copied;
    }

    private void setCurrentBuilderManipulatorsAsUsed() {
        this.usedManipulators.clear();
        this.usedManipulators.addAll(this.builderManipulators);
    }

    private List<BuilderManipulator> getActiveManipulators() {
        ArrayList<BuilderManipulator> activeManipulators = new ArrayList<BuilderManipulator>();
        for (int i = 0; i < this.builderManipulators.size(); ++i) {
            BuilderManipulator appliedManipulator;
            BuilderManipulator builderManipulator = this.builderManipulators.get(i);
            if (i < this.usedManipulators.size() && builderManipulator.equals(appliedManipulator = this.usedManipulators.get(i))) continue;
            activeManipulators.add(builderManipulator);
        }
        return activeManipulators;
    }

    private List<BuilderManipulator> extractOrderedManipulatorsFrom(List<BuilderManipulator> manipulators) {
        return manipulators.stream().filter(it -> !(it instanceof MetadataManipulator)).filter(it -> !(it instanceof PostArbitraryManipulator)).collect(Collectors.toList());
    }

    private List<MetadataManipulator> extractMetadataManipulatorsFrom(List<BuilderManipulator> manipulators) {
        return manipulators.stream().filter(MetadataManipulator.class::isInstance).map(MetadataManipulator.class::cast).sorted().collect(Collectors.toList());
    }

    private List<PostArbitraryManipulator> extractPostArbitraryManipulatorsFrom(List<BuilderManipulator> manipulators) {
        return manipulators.stream().filter(PostArbitraryManipulator.class::isInstance).map(PostArbitraryManipulator.class::cast).collect(Collectors.toList());
    }

    private Collection<ArbitraryNode> findNodesByExpression(ArbitraryExpression arbitraryExpression) {
        Collection<ArbitraryNode> foundNodes = this.tree.findAll(arbitraryExpression);
        ArbitraryNode<?> resetNode = this.tree.findFirstResetNode();
        if (resetNode != null && !resetNode.isLeafNode()) {
            this.traverser.traverse(resetNode, resetNode.isKeyOfMapStructure(), (FieldNameResolver)this.generator);
            foundNodes = this.tree.findAll(arbitraryExpression);
        }
        return foundNodes;
    }

    public boolean equals(Object obj) {
        Class<T> thatGenerateClazz;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryBuilder that = (ArbitraryBuilder)obj;
        Class<T> generateClazz = this.tree.getClazz();
        return generateClazz.equals(thatGenerateClazz = that.tree.getClazz()) && this.builderManipulators.equals(that.builderManipulators);
    }

    public int hashCode() {
        Class<T> generateClazz = this.tree.getClazz();
        return Objects.hash(generateClazz, this.builderManipulators);
    }

    private ArbitraryGenerator getGenerator(ArbitraryGenerator generator, ArbitraryCustomizers customizers) {
        if (generator instanceof WithFixtureCustomizer) {
            generator = ((WithFixtureCustomizer)((Object)generator)).withFixtureCustomizers(customizers);
        }
        return generator;
    }
}

