/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.ArbitraryOption;
import com.navercorp.fixturemonkey.FixtureMonkeyBuilder;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryTraverser;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizer;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.validator.ArbitraryValidator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;

public class FixtureMonkey {
    private final ArbitraryOption options;
    private final ArbitraryGenerator defaultGenerator;
    private final ArbitraryValidator validator;
    private final Map<Class<?>, ArbitraryGenerator> generatorMap;
    private final ArbitraryCustomizers arbitraryCustomizers;

    public FixtureMonkey(ArbitraryOption options, ArbitraryGenerator defaultGenerator, ArbitraryValidator validator, Map<Class<?>, ArbitraryGenerator> generatorMap, ArbitraryCustomizers arbitraryCustomizers) {
        this.options = options;
        this.defaultGenerator = defaultGenerator;
        this.validator = validator;
        this.generatorMap = generatorMap;
        this.arbitraryCustomizers = arbitraryCustomizers;
        options.applyArbitraryBuilders(this);
    }

    public static FixtureMonkey create() {
        return FixtureMonkey.builder().build();
    }

    public static FixtureMonkeyBuilder builder() {
        return new FixtureMonkeyBuilder();
    }

    public <T> Stream<T> giveMe(Class<T> type) {
        return this.giveMeBuilder(type, this.options).build().sampleStream();
    }

    public <T> Stream<T> giveMe(Class<T> type, ArbitraryCustomizer<T> customizer) {
        return this.giveMeBuilder(type, this.options, customizer).build().sampleStream();
    }

    public <T> List<T> giveMe(Class<T> type, int size) {
        return this.giveMe(type).limit(size).collect(Collectors.toList());
    }

    public <T> List<T> giveMe(Class<T> type, int size, ArbitraryCustomizer<T> customizer) {
        return this.giveMe(type, customizer).limit(size).collect(Collectors.toList());
    }

    public <T> T giveMeOne(Class<T> type) {
        return this.giveMe(type, 1).get(0);
    }

    public <T> T giveMeOne(Class<T> type, ArbitraryCustomizer<T> customizer) {
        return this.giveMe(type, 1, customizer).get(0);
    }

    public <T> Arbitrary<T> giveMeArbitrary(Class<T> type) {
        return this.giveMeBuilder(type, this.options).build();
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(Class<T> clazz) {
        return this.giveMeBuilder(clazz, this.options);
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(Class<T> clazz, ArbitraryOption options) {
        return this.giveMeBuilder(clazz, options, this.arbitraryCustomizers);
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(T value) {
        return new ArbitraryBuilder<Object>(() -> value, new ArbitraryTraverser(this.options), this.defaultGenerator, this.validator, this.arbitraryCustomizers, this.generatorMap);
    }

    private <T> ArbitraryBuilder<T> giveMeBuilder(Class<T> clazz, ArbitraryOption options, ArbitraryCustomizer<T> customizer) {
        ArbitraryCustomizers newArbitraryCustomizers = this.arbitraryCustomizers.mergeWith(Collections.singletonMap(clazz, customizer));
        return this.giveMeBuilder(clazz, options, newArbitraryCustomizers);
    }

    private <T> ArbitraryBuilder<T> giveMeBuilder(Class<T> clazz, ArbitraryOption option, ArbitraryCustomizers customizers) {
        ArbitraryBuilder<T> defaultArbitraryBuilder = option.getDefaultArbitraryBuilder(clazz);
        if (defaultArbitraryBuilder != null) {
            return defaultArbitraryBuilder;
        }
        return new ArbitraryBuilder<T>(clazz, option, this.defaultGenerator, this.validator, customizers, this.generatorMap);
    }
}

