/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class TypeSupports {
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_CLASS_MAPPER;

    private TypeSupports() {
    }

    public static boolean isNumberType(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    public static boolean isFloatType(Class<?> clazz) {
        return clazz == BigDecimal.class || clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
    }

    public static boolean isDateType(Class<?> clazz) {
        return Date.class.isAssignableFrom(clazz) || Temporal.class.isAssignableFrom(clazz);
    }

    public static <T, U> boolean isCompatibleType(Class<T> clazz1, Class<U> clazz2) {
        Class<U> toPrimitiveClazz2;
        if (clazz1 == Object.class || clazz2 == Object.class) {
            return true;
        }
        if (!clazz1.isPrimitive() && !clazz2.isPrimitive()) {
            return clazz1 == clazz2;
        }
        Class<T> toPrimitiveClazz1 = WRAPPER_PRIMITIVE_CLASS_MAPPER.getOrDefault(clazz1, clazz1);
        return toPrimitiveClazz1 == (toPrimitiveClazz2 = WRAPPER_PRIMITIVE_CLASS_MAPPER.getOrDefault(clazz2, clazz2));
    }

    static {
        HashMap<Class<Byte>, Class<Object>> map = new HashMap<Class<Byte>, Class<Object>>();
        map.put(Integer.class, Integer.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.class, Double.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Void.class, Void.TYPE);
        map.put(Byte.class, Byte.TYPE);
        WRAPPER_PRIMITIVE_CLASS_MAPPER = Collections.unmodifiableMap(map);
    }
}

