/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ArbitraryExpression
implements Comparable<ArbitraryExpression> {
    private final List<Exp> expList;

    private ArbitraryExpression(String expression) {
        this.expList = Arrays.stream(expression.split("\\.")).map(Exp::new).collect(Collectors.toList());
    }

    public static ArbitraryExpression from(String expression) {
        return new ArbitraryExpression(expression);
    }

    public ArbitraryExpression appendLeft(String expression) {
        String newStringExpression = expression + "." + this;
        return new ArbitraryExpression(newStringExpression);
    }

    public ArbitraryExpression appendRight(String expression) {
        String newStringExpression = this + "." + expression;
        return new ArbitraryExpression(newStringExpression);
    }

    public List<Exp> getExpList() {
        return this.expList;
    }

    public int size() {
        return this.expList.size();
    }

    public Exp get(int index) {
        return this.expList.get(index);
    }

    @Override
    public int compareTo(ArbitraryExpression arbitraryExpression) {
        List<Exp> expList = this.getExpList();
        List<Exp> oExpList = arbitraryExpression.getExpList();
        int expLength = Math.min(oExpList.size(), expList.size());
        for (int i = 0; i < expLength; ++i) {
            Exp oExp;
            Exp exp = expList.get(i);
            int expCompare = exp.compareTo(oExp = oExpList.get(i));
            if (expCompare == 0) continue;
            return expCompare;
        }
        return Integer.compare(oExpList.size(), expList.size());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryExpression fe = (ArbitraryExpression)obj;
        return this.expList.equals(fe.expList);
    }

    public int hashCode() {
        return Objects.hash(this.expList);
    }

    public String toString() {
        return this.expList.stream().map(Exp::toString).collect(Collectors.joining("."));
    }

    public static class Exp
    implements Comparable<Exp> {
        private final String name;
        private final List<ExpIndex> index = new ArrayList<ExpIndex>();

        public Exp(String expression) {
            if (expression.startsWith("$")) {
                expression = expression.replace("$", "HEAD_NAME");
            }
            int li = expression.indexOf(91);
            int ri = expression.indexOf(93);
            if (li != -1 && ri == -1 || li == -1 && ri != -1) {
                throw new IllegalArgumentException("expression is invalid. expression : " + expression);
            }
            if (li == -1) {
                this.name = expression;
            } else {
                this.name = expression.substring(0, li);
                while (li != -1 && ri != -1) {
                    if (ri - li > 1) {
                        String indexString = expression.substring(li + 1, ri);
                        int indexValue = indexString.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(indexString);
                        this.index.add(new ExpIndex(indexValue));
                    }
                    expression = expression.substring(ri + 1);
                    li = expression.indexOf(91);
                    ri = expression.indexOf(93);
                }
            }
        }

        public boolean hasAllIndex() {
            return !this.index.isEmpty() && this.index.stream().anyMatch(it -> it.equalsIgnoreAllIndex(Constants.ALL_INDEX_EXP_INDEX));
        }

        public boolean equalsIgnoreAllIndex(Exp exp) {
            int expLength;
            int length = this.index.size();
            if (length != (expLength = exp.index.size())) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this.index.get(i).equalsIgnoreAllIndex(exp.index.get(i))) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Exp exp = (Exp)obj;
            return this.name.equals(exp.name) && this.index.equals(exp.index);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.index);
        }

        public String getName() {
            return this.name;
        }

        public List<ExpIndex> getIndex() {
            return this.index;
        }

        public String toString() {
            String indexBrackets = this.index.stream().map(i -> "[" + i.toString() + "]").collect(Collectors.joining());
            return this.name + indexBrackets;
        }

        @Override
        public int compareTo(Exp exp) {
            List<ExpIndex> indices = this.getIndex();
            List<ExpIndex> oIndices = exp.getIndex();
            if (exp.name.equals(this.name)) {
                int indexLength = Math.min(oIndices.size(), indices.size());
                for (int i = 0; i < indexLength; ++i) {
                    ExpIndex index = indices.get(i);
                    ExpIndex oIndex = oIndices.get(i);
                    int indexCompare = oIndex.compareTo(index);
                    if (indexCompare == 0) continue;
                    return indexCompare;
                }
            }
            return Integer.compare(indices.size(), oIndices.size());
        }
    }

    public static final class ExpIndex
    implements Comparable<ExpIndex> {
        private final int index;

        public ExpIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equalsIgnoreAllIndex(ExpIndex expIndex) {
            return this.index == expIndex.index;
        }

        @Override
        public int compareTo(ExpIndex expIndex) {
            return Integer.compare(this.index, expIndex.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExpIndex expIndex = (ExpIndex)obj;
            return this.index == expIndex.index || this.index == Integer.MAX_VALUE || expIndex.index == Integer.MAX_VALUE;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.index == Integer.MAX_VALUE ? "*" : String.valueOf(this.index);
        }
    }
}

