/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.TypeSupports;
import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNullity;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeConstraint;
import com.navercorp.fixturemonkey.arbitrary.Cursor;
import com.navercorp.fixturemonkey.arbitrary.LazyValue;
import com.navercorp.fixturemonkey.arbitrary.NullArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.PostArbitraryManipulator;
import com.navercorp.fixturemonkey.arbitrary.PreArbitraryManipulator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArbitraryNode<T> {
    private final List<ArbitraryNode> children;
    private final ArbitraryType<T> type;
    private final String fieldName;
    private final String metadata;
    private final int indexOfIterable;
    private final FixtureNodeStatus<T> status;
    private final boolean keyOfMapStructure;
    private final double nullInject;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ArbitraryNode(List<ArbitraryNode> children, ArbitraryType<T> type, String fieldName, String metadata, int indexOfIterable, FixtureNodeStatus<T> status, boolean keyOfMapStructure, double nullInject) {
        this.children = new ArrayList<ArbitraryNode>();
        children.forEach(this::addChildNode);
        this.type = type;
        this.fieldName = fieldName;
        this.metadata = metadata;
        this.indexOfIterable = indexOfIterable;
        this.status = status.copy();
        this.keyOfMapStructure = keyOfMapStructure;
        this.nullInject = nullInject;
    }

    public static FixtureNodeBuilder builder() {
        return new FixtureNodeBuilder();
    }

    public void addChildNode(ArbitraryNode<?> child) {
        this.children.add(child);
    }

    public List<ArbitraryNode> findChildrenByCursor(Cursor cursor) {
        ArrayList<ArbitraryNode> foundChildren = new ArrayList<ArbitraryNode>();
        for (ArbitraryNode child : this.children) {
            if (child.isKeyOfMapStructure() || !cursor.isMatch(child)) continue;
            child.mark();
            foundChildren.add(child);
        }
        return foundChildren;
    }

    public void initializeElementSize() {
        NotEmpty notEmpty;
        if (!this.type.isContainer()) {
            throw new IllegalStateException("Can not initialize element size because node is not container.");
        }
        if (this.type.isOptional()) {
            this.setContainerSizeConstraint(new ContainerSizeConstraint(0, 1));
            return;
        }
        if (this.getContainerSizeConstraint() != null) {
            return;
        }
        Integer min = null;
        Integer max = null;
        Size size = this.type.getAnnotation(Size.class);
        if (size != null) {
            min = size.min();
            max = size.max();
        }
        if ((notEmpty = this.type.getAnnotation(NotEmpty.class)) != null) {
            min = min != null ? Integer.valueOf(Math.max(1, min)) : Integer.valueOf(1);
        }
        this.setContainerSizeConstraint(new ContainerSizeConstraint(min, max));
    }

    public void apply(PreArbitraryManipulator<T> preArbitraryManipulator) {
        if (preArbitraryManipulator instanceof AbstractArbitrarySet) {
            Class<?> toValueClazz;
            Object toValue = ((AbstractArbitrarySet)preArbitraryManipulator).getValue();
            Class<?> clazz = this.getType().getType();
            if (!(TypeSupports.isCompatibleType(clazz, toValueClazz = toValue.getClass()) || clazz.isAssignableFrom(toValueClazz) || Arbitrary.class.isAssignableFrom(toValueClazz))) {
                this.log.warn("field \"{}\" type is \"{}\", but given set value is \"{}\".", new Object[]{this.fieldName, clazz.getSimpleName(), toValueClazz.getSimpleName()});
            }
        } else {
            throw new IllegalArgumentException("Not Implemented PreArbitraryManipulator");
        }
        Arbitrary<T> appliedArbitrary = preArbitraryManipulator.apply(((FixtureNodeStatus)this.status).arbitrary);
        this.setFixed(true);
        this.setArbitrary(appliedArbitrary);
    }

    public void apply(ArbitraryNullity manipulator) {
        this.setActive(manipulator.toNull() == false);
    }

    public void setNullable(boolean nullable) {
        this.getStatus().setNullable(nullable);
    }

    public void setArbitrary(Arbitrary<T> arbitrary) {
        this.getStatus().setArbitrary(arbitrary);
    }

    public void setManipulated(boolean manipulated) {
        this.getStatus().setManipulated(manipulated);
    }

    public void setActive(boolean active) {
        this.getStatus().setActive(active);
    }

    public void setContainerSizeConstraint(ContainerSizeConstraint containerSizeConstraint) {
        this.getStatus().setContainerSizeConstraint(containerSizeConstraint);
    }

    public void setFixed(boolean fixed) {
        this.getStatus().setFixed(fixed);
    }

    public void setValue(Supplier<T> value) {
        this.getStatus().setValue(new LazyValue<T>(value));
    }

    public void setFixedValue(Supplier<T> value) {
        this.getStatus().setValue(new LazyValue<T>(value, true));
    }

    public void clearValue() {
        this.getStatus().setValue(null);
    }

    public void setReset(boolean reset) {
        this.getStatus().setReset(reset);
    }

    public void addPostArbitraryOperation(PostArbitraryManipulator postArbitraryManipulator) {
        this.status.addPostArbitraryManipulator(postArbitraryManipulator);
    }

    public Arbitrary<T> getArbitrary() {
        FixtureNodeStatus<T> status = this.getStatus();
        if (!status.isActive() && status.isManipulated()) {
            return Arbitraries.just(null);
        }
        return status.getArbitrary();
    }

    public boolean isNullable() {
        return ((FixtureNodeStatus)this.status).nullable;
    }

    public boolean isManipulated() {
        return ((FixtureNodeStatus)this.status).manipulated;
    }

    public boolean isActive() {
        return ((FixtureNodeStatus)this.status).active;
    }

    public List<ArbitraryNode> getChildren() {
        return this.children;
    }

    public ArbitraryType<T> getType() {
        if (this.type instanceof NullArbitraryType) {
            LazyValue<T> value = this.getValue();
            if (value == null) {
                return this.type;
            }
            return value.getArbitraryType();
        }
        return this.type;
    }

    public int getIndexOfIterable() {
        return this.indexOfIterable;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public double getNullInject() {
        return this.nullInject;
    }

    public boolean isKeyOfMapStructure() {
        return this.keyOfMapStructure;
    }

    public ContainerSizeConstraint getContainerSizeConstraint() {
        return ((FixtureNodeStatus)this.status).containerSizeConstraint;
    }

    public List<PostArbitraryManipulator<T>> getPostArbitraryManipulators() {
        return ((FixtureNodeStatus)this.status).postArbitraryManipulators;
    }

    public boolean isFixed() {
        return this.getStatus().isFixed();
    }

    public boolean isLeafNode() {
        return this.getChildren().isEmpty() && this.getArbitrary() != null;
    }

    public boolean isHead() {
        return this.getFieldName().equals("HEAD_NAME");
    }

    public LazyValue<T> getValue() {
        return this.getStatus().getValue();
    }

    public boolean isReset() {
        return this.getStatus().isReset();
    }

    public boolean isDecomposedAsNull() {
        LazyValue<T> value = this.getValue();
        return value != null && value.isEmpty();
    }

    public ArbitraryNode<T> copy() {
        ArrayList<ArbitraryNode> copyChildren = new ArrayList<ArbitraryNode>();
        List<ArbitraryNode> children = this.getChildren();
        for (ArbitraryNode child : children) {
            copyChildren.add(child.copy());
        }
        return ArbitraryNode.builder().children(copyChildren).type(this.getType()).fieldName(this.getFieldName()).metadata(this.getMetadata()).indexOfIterable(this.getIndexOfIterable()).status(this.getStatus().copy()).keyOfMapStructure(this.isKeyOfMapStructure()).nullInject(this.getNullInject()).nullable(this.isNullable()).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryNode that = (ArbitraryNode)obj;
        return this.indexOfIterable == that.indexOfIterable && this.keyOfMapStructure == that.keyOfMapStructure && Double.compare(that.nullInject, this.nullInject) == 0 && this.children.equals(that.children) && this.type.equals(that.type) && this.fieldName.equals(that.fieldName) && this.metadata.equals(that.metadata) && this.status.equals(that.status);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.type, this.fieldName, this.metadata, this.indexOfIterable, this.status, this.keyOfMapStructure, this.nullInject);
    }

    private FixtureNodeStatus<T> getStatus() {
        return this.status;
    }

    private void mark() {
        this.setActive(true);
        this.setManipulated(true);
        if (this.isDecomposedAsNull()) {
            this.setReset(true);
            this.setArbitrary(null);
            this.clearValue();
        }
    }

    public static final class FixtureNodeBuilder<T> {
        private List<ArbitraryNode> children = new ArrayList<ArbitraryNode>();
        private ArbitraryType<T> type = NullArbitraryType.INSTANCE;
        private String fieldName = "HEAD_NAME";
        private String metadata = "";
        private int indexOfIterable = Integer.MAX_VALUE;
        private FixtureNodeStatus<T> status = new FixtureNodeStatus();
        private boolean keyOfMapStructure = false;
        private double nullInject = 0.3f;

        public FixtureNodeBuilder<T> children(List<ArbitraryNode> children) {
            this.children = children;
            return this;
        }

        public FixtureNodeBuilder<T> addChild(ArbitraryNode<?> node) {
            this.children.add(node);
            return this;
        }

        public FixtureNodeBuilder<T> type(ArbitraryType<T> type) {
            this.type = type;
            return this;
        }

        public FixtureNodeBuilder<T> fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public FixtureNodeBuilder<T> metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public FixtureNodeBuilder<T> status(FixtureNodeStatus<T> status) {
            this.status = status;
            return this;
        }

        public FixtureNodeBuilder<T> nullable(boolean nullable) {
            ((FixtureNodeStatus)this.status).nullable = nullable;
            return this;
        }

        public FixtureNodeBuilder<T> keyOfMapStructure(boolean keyOfMapStructure) {
            this.keyOfMapStructure = keyOfMapStructure;
            return this;
        }

        public FixtureNodeBuilder<T> indexOfIterable(int indexOfIterable) {
            this.indexOfIterable = indexOfIterable;
            return this;
        }

        public FixtureNodeBuilder<T> nullInject(double nullInject) {
            this.nullInject = nullInject;
            return this;
        }

        public FixtureNodeBuilder<T> arbitrary(Arbitrary arbitrary) {
            ((FixtureNodeStatus)this.status).arbitrary = arbitrary;
            return this;
        }

        public FixtureNodeBuilder<T> value(LazyValue<T> value) {
            ((FixtureNodeStatus)this.status).value = value;
            return this;
        }

        public FixtureNodeBuilder<T> value(Supplier<T> valueSupplier) {
            ((FixtureNodeStatus)this.status).value = new LazyValue<T>(valueSupplier);
            return this;
        }

        public FixtureNodeBuilder<T> value(T value) {
            ((FixtureNodeStatus)this.status).value = new LazyValue<T>(value);
            return this;
        }

        public FixtureNodeBuilder<T> active(boolean active) {
            ((FixtureNodeStatus)this.status).active = active;
            return this;
        }

        public ArbitraryNode<T> build() {
            return new ArbitraryNode<T>(this.children, this.type, this.fieldName, this.metadata, this.indexOfIterable, this.status, this.keyOfMapStructure, this.nullInject);
        }
    }

    private static final class FixtureNodeStatus<T> {
        @Nullable
        private Arbitrary<T> arbitrary = null;
        private ContainerSizeConstraint containerSizeConstraint;
        private List<PostArbitraryManipulator<T>> postArbitraryManipulators = new ArrayList<PostArbitraryManipulator<T>>();
        private LazyValue<T> value = null;
        private boolean nullable = false;
        private boolean manipulated = false;
        private boolean active = true;
        private boolean fixed = false;
        private boolean reset = false;

        private FixtureNodeStatus() {
        }

        public FixtureNodeStatus(@Nullable Arbitrary<T> arbitrary, ContainerSizeConstraint containerSizeConstraint, List<PostArbitraryManipulator<T>> postArbitraryManipulators, LazyValue<T> value, boolean nullable, boolean manipulated, boolean active, boolean fixed, boolean reset) {
            this.arbitrary = arbitrary;
            this.containerSizeConstraint = containerSizeConstraint;
            this.postArbitraryManipulators = postArbitraryManipulators;
            this.value = value;
            this.nullable = nullable;
            this.manipulated = manipulated;
            this.active = active;
            this.fixed = fixed;
            this.reset = reset;
        }

        @Nullable
        public Arbitrary<T> getArbitrary() {
            return this.arbitrary;
        }

        public ContainerSizeConstraint getContainerSizeConstraint() {
            return this.containerSizeConstraint;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isManipulated() {
            return this.manipulated;
        }

        public boolean isActive() {
            return this.active;
        }

        public List<PostArbitraryManipulator<T>> getPostArbitraryManipulators() {
            return this.postArbitraryManipulators;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public LazyValue<T> getValue() {
            return this.value;
        }

        public boolean isReset() {
            return this.reset;
        }

        public void setArbitrary(@Nullable Arbitrary<T> arbitrary) {
            this.arbitrary = arbitrary;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setManipulated(boolean manipulated) {
            this.manipulated = manipulated;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setReset(boolean reset) {
            this.reset = reset;
        }

        public void setContainerSizeConstraint(@Nullable ContainerSizeConstraint containerSizeConstraint) {
            this.containerSizeConstraint = containerSizeConstraint;
        }

        public void addPostArbitraryManipulator(PostArbitraryManipulator<T> postArbitraryManipulator) {
            this.postArbitraryManipulators.add(postArbitraryManipulator);
        }

        public void setPostArbitraryManipulators(List<PostArbitraryManipulator<T>> postArbitraryManipulators) {
            this.postArbitraryManipulators = postArbitraryManipulators;
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        public void setValue(LazyValue<T> value) {
            this.value = value;
        }

        public FixtureNodeStatus<T> copy() {
            return new FixtureNodeStatus<T>(this.getArbitrary(), this.getContainerSizeConstraint(), this.getPostArbitraryManipulators(), this.getValue(), this.isNullable(), this.isManipulated(), this.isActive(), this.isFixed(), this.isReset());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FixtureNodeStatus that = (FixtureNodeStatus)obj;
            return this.nullable == that.nullable && this.manipulated == that.manipulated && this.active == that.active;
        }

        public int hashCode() {
            return Objects.hash(this.nullable, this.manipulated, this.active);
        }
    }
}

