/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import java.util.Objects;
import net.jqwik.api.Arbitrary;

public final class ArbitrarySetArbitrary<T>
extends AbstractArbitrarySet<T> {
    private final Arbitrary<T> value;
    private long limit;

    public ArbitrarySetArbitrary(ArbitraryExpression arbitraryExpression, Arbitrary<T> value, long limit) {
        super(arbitraryExpression);
        this.value = value;
        this.limit = limit;
    }

    public ArbitrarySetArbitrary(ArbitraryExpression arbitraryExpression, Arbitrary<T> value) {
        this(arbitraryExpression, value, Long.MAX_VALUE);
    }

    public Arbitrary<T> getValue() {
        return this.value;
    }

    @Override
    public Arbitrary<T> apply(Arbitrary<T> from) {
        if (this.limit > 0L) {
            --this.limit;
            return this.value;
        }
        return from;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArbitrarySetArbitrary that = (ArbitrarySetArbitrary)obj;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public ArbitrarySetArbitrary<T> copy() {
        return new ArbitrarySetArbitrary<T>(this.getArbitraryExpression(), this.value);
    }
}

