/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import java.util.Objects;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;

public final class ArbitrarySetPrefix
extends AbstractArbitrarySet<String> {
    private final Arbitrary<String> value;

    public ArbitrarySetPrefix(ArbitraryExpression fixtureExpression, Arbitrary<String> value) {
        super(fixtureExpression);
        this.value = value;
    }

    public Arbitrary<String> getValue() {
        return this.value;
    }

    @Override
    public Arbitrary<String> apply(Arbitrary<String> from) {
        return Combinators.combine(this.value, from).as((prefix, fromValue) -> {
            String concatString = prefix + fromValue;
            int remainLength = concatString.length() - prefix.length();
            return concatString.substring(0, Math.max(prefix.length(), remainLength));
        });
    }

    @Override
    public ArbitrarySetPrefix copy() {
        return new ArbitrarySetPrefix(this.getArbitraryExpression(), this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArbitrarySetPrefix that = (ArbitrarySetPrefix)obj;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

