/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import java.util.Objects;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;

public final class ArbitrarySetSuffix
extends AbstractArbitrarySet<String> {
    private final Arbitrary<String> value;

    public ArbitrarySetSuffix(ArbitraryExpression fixtureExpression, Arbitrary<String> value) {
        super(fixtureExpression);
        this.value = value;
    }

    public Arbitrary<String> getValue() {
        return this.value;
    }

    @Override
    public Arbitrary<String> apply(Arbitrary<String> from) {
        return Combinators.combine(this.value, from).as((suffix, fromValue) -> {
            String concatString = fromValue + suffix;
            int remainLength = concatString.length() - suffix.length();
            return concatString.substring(Math.min(remainLength, suffix.length()));
        });
    }

    @Override
    public ArbitrarySetSuffix copy() {
        return new ArbitrarySetSuffix(this.getArbitraryExpression(), this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArbitrarySetSuffix that = (ArbitrarySetSuffix)obj;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

