/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.ArbitraryOption;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryTree;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ArrayArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.DefaultContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.InterfaceSupplier;
import com.navercorp.fixturemonkey.arbitrary.LazyValue;
import com.navercorp.fixturemonkey.arbitrary.MapArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.OptionalArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.generator.AnnotatedArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.AnnotationSource;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import org.junit.platform.commons.util.ReflectionUtils;

public final class ArbitraryTraverser {
    public static final ArbitraryTraverser INSTANCE = new ArbitraryTraverser(ArbitraryOption.DEFAULT_ARBITRARY_OPTIONS);
    private final ArbitraryOption arbitraryOption;

    public ArbitraryTraverser(ArbitraryOption arbitraryOption) {
        this.arbitraryOption = arbitraryOption;
    }

    public <T> void traverse(ArbitraryTree<T> tree, boolean keyOfMapStructure, FieldNameResolver fieldNameResolver) {
        this.traverse(tree.getHead(), keyOfMapStructure, fieldNameResolver);
    }

    public <T> void traverse(ArbitraryNode<T> node, boolean keyOfMapStructure, FieldNameResolver fieldNameResolver) {
        LazyValue<T> value = node.getValue();
        if (value != null) {
            value.clear();
        }
        this.doTraverse(node, keyOfMapStructure, true, fieldNameResolver);
    }

    private <T> void doTraverse(ArbitraryNode<T> node, boolean keyOfMapStructure, boolean active, FieldNameResolver fieldNameResolver) {
        node.getChildren().clear();
        this.initializeDefaultArbitrary(node);
        LazyValue<T> nowValue = node.getValue();
        ArbitraryType<T> nowNodeType = node.getType();
        Class<?> clazz = nowNodeType.getType();
        ContainerArbitraryNodeGenerator containerArbitraryNodeGenerator = this.arbitraryOption.getContainerArbitraryNodeGenerator(nowNodeType.getType());
        if (this.isTraversable(nowNodeType)) {
            List<Field> fields = this.getFields(clazz);
            for (Field field : fields) {
                boolean nextActive;
                ArbitraryType arbitraryType = this.getArbitraryType(field);
                double nullInject = this.arbitraryOption.getNullInject();
                boolean defaultNotNull = this.arbitraryOption.isDefaultNotNull();
                boolean nullable = this.isNullableField(field, defaultNotNull);
                LazyValue<?> nextValue = this.getNextValue(nowValue, field);
                nullable = nextValue == null && nullable;
                boolean bl = nextActive = (nextValue == null || !nextValue.isEmpty()) && active;
                if (node.isDecomposedAsNull()) {
                    node.setArbitrary(Arbitraries.just(null));
                }
                ArbitraryNode<LazyValue<?>> nextNode = ArbitraryNode.builder().type(arbitraryType).fieldName(fieldNameResolver.resolveFieldName(field)).nullable(nullable).nullInject(nullInject).keyOfMapStructure(keyOfMapStructure).value(nextValue).active(nextActive).build();
                node.addChildNode(nextNode);
                this.doTraverse(nextNode, false, active, fieldNameResolver);
            }
        } else if (nowNodeType.isContainer() || containerArbitraryNodeGenerator != null) {
            if (containerArbitraryNodeGenerator != null) {
                this.traverseContainer(node, active, fieldNameResolver, containerArbitraryNodeGenerator);
            } else if (nowNodeType.isMap() || nowNodeType.isMapEntry()) {
                this.traverseContainer(node, active, fieldNameResolver, MapArbitraryNodeGenerator.INSTANCE);
            } else if (nowNodeType.isArray()) {
                this.traverseContainer(node, active, fieldNameResolver, ArrayArbitraryNodeGenerator.INSTANCE);
            } else if (nowNodeType.isOptional()) {
                this.traverseContainer(node, active, fieldNameResolver, OptionalArbitraryNodeGenerator.INSTANCE);
            } else {
                this.traverseContainer(node, active, fieldNameResolver, DefaultContainerArbitraryNodeGenerator.INSTANCE);
            }
        } else if (nowValue != null) {
            node.setManipulated(true);
            node.setArbitrary(Arbitraries.just(nowValue.get()));
        } else if (this.arbitraryOption.isDefaultArbitraryType(nowNodeType.getType()) && this.arbitraryOption.isGeneratableClass(clazz)) {
            Arbitrary<T> registeredArbitrary = this.registeredArbitrary(node);
            node.setArbitrary(registeredArbitrary);
        } else if (nowNodeType.isEnum()) {
            Arbitrary arbitrary = Arbitraries.of(clazz);
            node.setArbitrary(arbitrary);
        } else if (nowNodeType.isInterface() || nowNodeType.isAbstract()) {
            InterfaceSupplier<?> interfaceSupplier = this.arbitraryOption.getInterfaceSupplierOrDefault(nowNodeType.getType());
            node.setArbitrary(Arbitraries.just(interfaceSupplier.get(nowNodeType.getType())));
        } else {
            node.setArbitrary(Arbitraries.just(null));
        }
    }

    private <T> void traverseContainer(ArbitraryNode<T> currentNode, boolean active, FieldNameResolver fieldNameResolver, ContainerArbitraryNodeGenerator containerArbitraryNodeGenerator) {
        List<ArbitraryNode<?>> nodes = containerArbitraryNodeGenerator.generate(currentNode, fieldNameResolver);
        for (ArbitraryNode<?> node : nodes) {
            currentNode.addChildNode(node);
            this.doTraverse(node, node.isKeyOfMapStructure(), active, fieldNameResolver);
        }
    }

    private <T> Arbitrary<T> registeredArbitrary(ArbitraryNode<T> currentNode) {
        ArbitraryType<T> type = currentNode.getType();
        AnnotatedType argsType = type.getAnnotatedType();
        Class clazz = argsType != null ? (Class)argsType.getType() : type.getType();
        AnnotationSource annotationSource = new AnnotationSource(type.getAnnotations());
        Map<Class<?>, AnnotatedArbitraryGenerator<?>> annotatedArbitraryMap = this.arbitraryOption.getAnnotatedArbitraryMap();
        return Optional.ofNullable(annotatedArbitraryMap.get(clazz)).map(arbitraryGenerator -> arbitraryGenerator.generate(annotationSource)).orElseThrow(() -> new IllegalArgumentException("Class is not registered " + clazz.getName()));
    }

    @Nullable
    private <T> LazyValue<?> getNextValue(LazyValue<T> currentValue, Field field) {
        if (currentValue == null) {
            return null;
        }
        return currentValue.isEmpty() ? new LazyValue<Object>(null) : new LazyValue<Object>(this.extractValue(currentValue.get(), field));
    }

    private <T> void initializeDefaultArbitrary(ArbitraryNode<T> node) {
        Class<?> clazz = node.getType().getType();
        ArbitraryBuilder<?> defaultArbitraryBuilder = this.arbitraryOption.getDefaultArbitraryBuilder(clazz);
        if (defaultArbitraryBuilder != null && !node.isHead() && node.getValue() == null) {
            node.setValue(() -> defaultArbitraryBuilder.sample());
            node.setManipulated(true);
        }
    }

    private List<Field> getFields(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findFields(clazz, this::availableField, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
    }

    private <T> Object extractValue(T value, Field field) {
        try {
            field.setAccessible(true);
            return field.get(value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can not extract value");
        }
    }

    private ArbitraryType getArbitraryType(Field field) {
        List<Annotation> annotations = Arrays.asList(field.getAnnotations());
        return new ArbitraryType(field.getType(), field.getAnnotatedType(), annotations);
    }

    private boolean isNullableField(Field field, boolean defaultNotNull) {
        ArbitraryType arbitraryType = this.getArbitraryType(field);
        boolean nullable = this.arbitraryOption.getNullableArbitraryEvaluator().isNullable(field);
        if (arbitraryType.isContainer()) {
            return nullable && this.arbitraryOption.isNullableContainer();
        }
        if (arbitraryType.isPrimitive()) {
            return false;
        }
        if (arbitraryType.getAnnotation(NotEmpty.class) != null || field.getType() == String.class && arbitraryType.getAnnotation(NotBlank.class) != null) {
            return false;
        }
        if (arbitraryType.getAnnotation(Nullable.class) != null) {
            return true;
        }
        if (!nullable) {
            return false;
        }
        boolean hasNotNullAnnotations = arbitraryType.getAnnotations().stream().noneMatch(it -> this.arbitraryOption.isNonNullAnnotation((Annotation)it));
        if (!hasNotNullAnnotations) {
            return false;
        }
        return !defaultNotNull;
    }

    private boolean availableField(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    private boolean isTraversable(ArbitraryType<?> type) {
        Class<?> clazz = type.getType();
        if (clazz == null) {
            return false;
        }
        return this.arbitraryOption.isExceptGeneratablePackage(clazz) && this.arbitraryOption.isGeneratableClass(clazz) && !this.arbitraryOption.isDefaultArbitraryType(clazz) && this.arbitraryOption.getContainerArbitraryNodeGenerator(clazz) == null && !type.isContainer() && !type.isOptional() && !type.isEnum() && !type.isInterface() && !type.isAbstract();
    }
}

