/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryValue;
import com.navercorp.fixturemonkey.arbitrary.Cursor;
import com.navercorp.fixturemonkey.arbitrary.CursorFactory;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.validator.ArbitraryValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolation;
import net.jqwik.api.Arbitrary;

public final class ArbitraryTree<T> {
    private ArbitraryNode<T> head;

    public ArbitraryTree(ArbitraryNode<T> head) {
        this.head = head;
    }

    public Collection<ArbitraryNode> findAll(ArbitraryExpression arbitraryExpression) {
        LinkedList<ArbitraryNode> selectNodes = new LinkedList<ArbitraryNode>();
        selectNodes.add(this.head);
        this.head.setManipulated(true);
        ArrayList<ArbitraryNode> nextNodes = new ArrayList<ArbitraryNode>();
        List<Cursor> cursors = CursorFactory.create(arbitraryExpression);
        for (Cursor cursor : cursors) {
            while (!selectNodes.isEmpty()) {
                ArbitraryNode selectNode = (ArbitraryNode)selectNodes.poll();
                nextNodes.addAll(selectNode.findChildrenByCursor(cursor));
            }
            selectNodes.addAll(nextNodes);
            nextNodes.clear();
        }
        return selectNodes;
    }

    @Nullable
    public ArbitraryNode<?> findFirstResetNode() {
        return this.doFindFirstResetNode(this.head);
    }

    @Nullable
    private ArbitraryNode<?> doFindFirstResetNode(ArbitraryNode<?> node) {
        boolean reset = node.isReset();
        node.setReset(false);
        if (reset) {
            return node;
        }
        List<ArbitraryNode> children = node.getChildren();
        for (ArbitraryNode child : children) {
            ArbitraryNode<?> result = this.doFindFirstResetNode(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void update(ArbitraryGenerator defaultGenerator, Map<Class<?>, ArbitraryGenerator> generatorMap) {
        this.update(this.head, defaultGenerator, generatorMap);
    }

    private <U> void update(ArbitraryNode<U> entryNode, ArbitraryGenerator defaultGenerator, Map<Class<?>, ArbitraryGenerator> generatorMap) {
        if (!entryNode.isLeafNode() && !entryNode.isFixed() && entryNode.isActive()) {
            for (ArbitraryNode nextChild : entryNode.getChildren()) {
                this.update(nextChild, defaultGenerator, generatorMap);
            }
            Class<?> clazz = entryNode.getType().getType();
            ArbitraryGenerator generator = this.getGenerator(clazz, defaultGenerator, generatorMap);
            entryNode.setArbitrary(generator.generate(entryNode.getType(), entryNode.getChildren()));
        }
        entryNode.getPostArbitraryManipulators().forEach(operation -> entryNode.setArbitrary(operation.apply(entryNode.getArbitrary())));
        if (entryNode.isNullable() && !entryNode.isManipulated()) {
            entryNode.setArbitrary(entryNode.getArbitrary().injectNull(entryNode.getNullInject()));
        }
    }

    public ArbitraryGenerator getGenerator(Class<?> clazz, ArbitraryGenerator defaultGenerator, Map<Class<?>, ArbitraryGenerator> generatorMap) {
        return generatorMap.getOrDefault(clazz, defaultGenerator);
    }

    public Arbitrary<T> result(Supplier<Arbitrary<T>> generateArbitrary, ArbitraryValidator validator, boolean validOnly) {
        return new ArbitraryValue<T>(generateArbitrary, validator, validOnly, new ConcurrentHashMap<String, ConstraintViolation>());
    }

    public Class<T> getClazz() {
        return this.head.getType().getType();
    }

    public Arbitrary<T> getArbitrary() {
        return this.head.getArbitrary();
    }

    public void clearDecomposedValue() {
        this.head.clearValue();
    }

    public void setDecomposedValue(Supplier<T> supplier) {
        this.head.setValue(supplier);
    }

    public void setFixedDecomposedValue(Supplier<T> supplier) {
        this.head.setFixedValue(supplier);
    }

    public ArbitraryTree<T> copy() {
        return new ArbitraryTree<T>(this.head.copy());
    }

    ArbitraryNode<T> getHead() {
        return this.head;
    }
}

