/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.BaseStream;
import javax.annotation.Nullable;

public class ArbitraryType<T> {
    private final Class<T> type;
    private final AnnotatedType annotatedType;
    private final List<Annotation> annotations;

    public ArbitraryType(Class<T> type, AnnotatedType annotatedType, List<Annotation> annotations) {
        this.type = type;
        this.annotatedType = annotatedType;
        this.annotations = Collections.unmodifiableList(annotations);
    }

    public ArbitraryType(Class<T> type) {
        this.type = type;
        this.annotatedType = null;
        this.annotations = Collections.emptyList();
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Nullable
    public <U extends Annotation> U getAnnotation(Class<U> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("annotationType not exists");
        }
        return (U)((Annotation)this.annotations.stream().filter(it -> it.annotationType() == annotationType).findAny().orElse(null));
    }

    public <U> ArbitraryType<U> getGenericArbitraryType(int index) {
        Class<?> childClazz = this.findGenericType(index).orElseThrow(() -> new IllegalArgumentException(index + "th childClazz not exists"));
        AnnotatedType childAnnotatedType = this.findGenericAnnotatedType(index).orElseThrow(() -> new IllegalArgumentException(index + "th childAnnotatedType not exists"));
        return new ArbitraryType(childClazz, childAnnotatedType, Arrays.asList(childAnnotatedType.getAnnotations()));
    }

    public <U> ArbitraryType<U> getArrayArbitraryType() {
        if (!this.isArray()) {
            throw new IllegalStateException("FixtureType is not array but getArrayFixtureType is called.");
        }
        AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)this.getAnnotatedType();
        Class arrayType = (Class)annotatedArrayType.getType();
        Class<?> genericClazz = arrayType.getComponentType();
        AnnotatedType genericAnnotatedType = annotatedArrayType.getAnnotatedGenericComponentType();
        return new ArbitraryType(genericClazz, genericAnnotatedType, Arrays.asList(genericAnnotatedType.getAnnotations()));
    }

    public boolean isContainer() {
        return this.isGenericType() && (this.isCollection() || this.isMap() || this.isMapEntry() || this.isArray() || this.isStream() || this.isOptional() || this.isIterator() || this.isIterable());
    }

    private boolean isCollection() {
        return Collection.class.isAssignableFrom(this.type);
    }

    private boolean isIterable() {
        return Iterable.class.isAssignableFrom(this.type);
    }

    private boolean isIterator() {
        return Iterator.class.isAssignableFrom(this.type);
    }

    public boolean isArray() {
        return this.annotatedType instanceof AnnotatedArrayType && ((Class)this.annotatedType.getType()).isArray();
    }

    public boolean isMapEntry() {
        return Map.Entry.class.isAssignableFrom(this.type);
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.type);
    }

    public boolean isGenericType() {
        return this.annotatedType instanceof AnnotatedArrayType || this.annotatedType instanceof AnnotatedParameterizedType;
    }

    public boolean isOptional() {
        return Optional.class.isAssignableFrom(this.type);
    }

    public boolean isStream() {
        return BaseStream.class.isAssignableFrom(this.type);
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean isInterface() {
        return this.type.isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.type.getModifiers());
    }

    public Class<?> getType() {
        return this.type;
    }

    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    private Optional<AnnotatedType> findGenericAnnotatedType(int index) {
        if (this.annotatedType == null) {
            return Optional.empty();
        }
        AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)this.annotatedType;
        AnnotatedType[] annotatedActualTypeArguments = parameterizedType.getAnnotatedActualTypeArguments();
        if (annotatedActualTypeArguments.length <= index) {
            return Optional.empty();
        }
        return Optional.of(annotatedActualTypeArguments[index]);
    }

    private Optional<Class<?>> findGenericType(int index) {
        return this.findGenericAnnotatedType(index).map(this::findGenericType);
    }

    private Class<?> findGenericType(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)annotatedType.getType();
            return (Class)parameterType.getRawType();
        }
        return (Class)annotatedType.getType();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryType that = (ArbitraryType)obj;
        return this.type.equals(that.type) && Objects.equals(this.annotatedType, that.annotatedType) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.annotatedType, this.annotations);
    }
}

