/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.validator.ArbitraryValidator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamArbitrary;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArbitraryValue<T>
implements Arbitrary<T> {
    private final Supplier<Arbitrary<T>> generateArbitrary;
    private Arbitrary<T> arbitrary;
    private final boolean validOnly;
    private final ArbitraryValidator validator;
    private final Map<String, ConstraintViolation> violations;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Exception lastException;

    public ArbitraryValue(Supplier<Arbitrary<T>> generateArbitrary, ArbitraryValidator validator, boolean validOnly, Map<String, ConstraintViolation> violations) {
        this.generateArbitrary = generateArbitrary;
        this.validator = validator;
        this.validOnly = validOnly;
        this.violations = violations;
    }

    public synchronized RandomGenerator<T> generator(int genSize) {
        try {
            RandomGenerator randomGenerator = this.getArbitrary().generator(genSize);
            return randomGenerator;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public Arbitrary<Object> asGeneric() {
        return new ArbitraryValue<Object>(() -> this.getArbitrary().asGeneric(), this.validator, this.validOnly, this.violations);
    }

    public boolean isUnique() {
        return this.getArbitrary().isUnique();
    }

    public synchronized Optional<ExhaustiveGenerator<T>> exhaustive() {
        try {
            Optional optional = this.getArbitrary().exhaustive();
            return optional;
        }
        finally {
            this.arbitrary = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        try {
            Optional optional = this.getArbitrary().exhaustive(maxNumberOfSamples);
            return optional;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized EdgeCases<T> edgeCases() {
        try {
            EdgeCases edgeCases = this.getArbitrary().edgeCases();
            return edgeCases;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized Optional<Stream<T>> allValues() {
        try {
            Optional optional = this.getArbitrary().allValues();
            return optional;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized void forEachValue(Consumer<? super T> action) {
        try {
            this.getArbitrary().forEachValue(action);
        }
        finally {
            this.arbitrary = null;
        }
    }

    public Arbitrary<T> filter(Predicate<T> filterPredicate) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().filter(filterPredicate), this.validator, this.validOnly, this.violations);
    }

    public <U> Arbitrary<U> map(Function<T, U> mapper) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().map(mapper), this.validator, this.validOnly, this.violations);
    }

    public <U> Arbitrary<U> flatMap(Function<T, Arbitrary<U>> mapper) {
        return new ArbitraryValue<T>(() -> this.convert(this.getArbitrary(), it -> it.flatMap(mapper)), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<T> injectNull(double nullProbability) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().injectNull(nullProbability), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<T> unique() {
        return new ArbitraryValue<T>(() -> this.getArbitrary().unique(), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<T> fixGenSize(int genSize) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().fixGenSize(genSize), this.validator, this.validOnly, this.violations);
    }

    public synchronized ListArbitrary<T> list() {
        try {
            ListArbitrary listArbitrary = this.getArbitrary().list();
            return listArbitrary;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized SetArbitrary<T> set() {
        try {
            SetArbitrary setArbitrary = this.getArbitrary().set();
            return setArbitrary;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized StreamArbitrary<T> stream() {
        try {
            StreamArbitrary streamArbitrary = this.getArbitrary().stream();
            return streamArbitrary;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized IteratorArbitrary<T> iterator() {
        try {
            IteratorArbitrary iteratorArbitrary = this.getArbitrary().iterator();
            return iteratorArbitrary;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized <A> StreamableArbitrary<T, A> array(Class<A> arrayClass) {
        try {
            StreamableArbitrary streamableArbitrary = this.getArbitrary().array(arrayClass);
            return streamableArbitrary;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public Arbitrary<Optional<T>> optional() {
        return new ArbitraryValue<Optional<T>>(() -> this.convert(this.getArbitrary(), Arbitrary::optional), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<List<T>> collect(Predicate<List<T>> until) {
        return new ArbitraryValue<List<T>>(() -> this.convert(this.getArbitrary(), it -> it.collect(until)), this.validator, this.validOnly, this.violations);
    }

    public synchronized Stream<T> sampleStream() {
        try {
            Stream<Object> stream = this.getArbitrary().filter(this.validateFilter(this.validOnly)).sampleStream().map(Optional::ofNullable).map((? super T it) -> it.orElse(null));
            return stream;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public synchronized T sample() {
        try {
            Object object = this.getArbitrary().filter(this.validateFilter(this.validOnly)).sample();
            return (T)object;
        }
        catch (TooManyFilterMissesException ex) {
            StringBuilder builder = new StringBuilder();
            this.violations.values().forEach(violation -> builder.append("- violation: ").append(violation.getMessage()).append(", type: ").append(violation.getRootBeanClass()).append(", property: ").append(violation.getPropertyPath()).append(", invalidValue: ").append(violation.getInvalidValue()).append("\n"));
            this.log.error("Fail to create valid arbitrary.\n\nFixture factory Constraint Violation messages. \n\n" + builder, (Throwable)this.lastException);
            throw ex;
        }
        finally {
            this.arbitrary = null;
        }
    }

    public Arbitrary<T> injectDuplicates(double duplicateProbability) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().injectDuplicates(duplicateProbability), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<Tuple.Tuple1<T>> tuple1() {
        return new ArbitraryValue<Tuple.Tuple1<T>>(() -> this.convert(this.getArbitrary(), Arbitrary::tuple1), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<Tuple.Tuple2<T, T>> tuple2() {
        return new ArbitraryValue<Tuple.Tuple2<T, T>>(() -> this.convert(this.getArbitrary(), Arbitrary::tuple2), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<Tuple.Tuple3<T, T, T>> tuple3() {
        return new ArbitraryValue<Tuple.Tuple3<T, T, T>>(() -> this.convert(this.getArbitrary(), Arbitrary::tuple3), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<Tuple.Tuple4<T, T, T, T>> tuple4() {
        return new ArbitraryValue<Tuple.Tuple4<T, T, T, T>>(() -> this.convert(this.getArbitrary(), Arbitrary::tuple4), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<Tuple.Tuple5<T, T, T, T, T>> tuple5() {
        return new ArbitraryValue<Tuple.Tuple5<T, T, T, T, T>>(() -> this.convert(this.getArbitrary(), Arbitrary::tuple5), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<T> ignoreException(Class<? extends Throwable> exceptionType) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().ignoreException(exceptionType), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<T> dontShrink() {
        return new ArbitraryValue<T>(() -> this.getArbitrary().dontShrink(), this.validator, this.validOnly, this.violations);
    }

    public Arbitrary<T> edgeCases(Consumer<EdgeCases.Config<T>> configurator) {
        return new ArbitraryValue<T>(() -> this.getArbitrary().edgeCases(configurator), this.validator, this.validOnly, this.violations);
    }

    private synchronized Arbitrary<T> getArbitrary() {
        if (this.arbitrary == null) {
            this.arbitrary = this.generateArbitrary.get();
        }
        return this.arbitrary;
    }

    private Predicate validateFilter(boolean validOnly) {
        return fixture -> {
            if (!validOnly) {
                return true;
            }
            if (fixture == null) {
                return true;
            }
            try {
                this.validator.validate(fixture);
                return true;
            }
            catch (ConstraintViolationException ex) {
                ex.getConstraintViolations().forEach(violation -> this.violations.put(violation.getRootBeanClass().getName() + violation.getPropertyPath(), (ConstraintViolation)violation));
                this.lastException = ex;
                return false;
            }
        };
    }

    private <U> Arbitrary<U> convert(Arbitrary<T> arbitrary, Function<Arbitrary<T>, Arbitrary<U>> mapper) {
        return mapper.apply(arbitrary.filter(this.validateFilter(this.validOnly)));
    }
}

