/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeConstraint;
import com.navercorp.fixturemonkey.arbitrary.LazyValue;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.Arbitraries;

public class ArrayArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final ArrayArbitraryNodeGenerator INSTANCE = new ArrayArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        int elementSize = Integer.MAX_VALUE;
        int currentIndex = 0;
        ArbitraryType<T> clazz = nowNode.getType();
        ArbitraryType childType = clazz.getArrayArbitraryType();
        String fieldName = nowNode.getFieldName();
        LazyValue<T> lazyValue = nowNode.getValue();
        ArrayList generatedNodeList = new ArrayList();
        if (lazyValue != null) {
            T value = lazyValue.get();
            ContainerSizeConstraint containerSizeConstraint = nowNode.getContainerSizeConstraint();
            if (value == null) {
                nowNode.setArbitrary(Arbitraries.just(null));
                return generatedNodeList;
            }
            int length = Array.getLength(value);
            if (containerSizeConstraint != null) {
                elementSize = containerSizeConstraint.getArbitraryElementSize();
            }
            for (currentIndex = 0; currentIndex < length && currentIndex < elementSize; ++currentIndex) {
                Object nextValue = Array.get(value, currentIndex);
                ArbitraryNode<Object> nextNode = ArbitraryNode.builder().type(childType).fieldName(fieldName).indexOfIterable(currentIndex).value(nextValue).build();
                generatedNodeList.add(nextNode);
            }
            if (containerSizeConstraint == null) {
                nowNode.setContainerSizeConstraint(new ContainerSizeConstraint(length, length));
                return generatedNodeList;
            }
        }
        nowNode.initializeElementSize();
        if (this.isNotInitialized(elementSize)) {
            elementSize = nowNode.getContainerSizeConstraint().getArbitraryElementSize();
        }
        for (int i = currentIndex; i < elementSize; ++i) {
            ArbitraryNode genericFrame = ArbitraryNode.builder().type(childType).fieldName(fieldName).indexOfIterable(i).nullable(false).nullInject(0.0).build();
            generatedNodeList.add(genericFrame);
        }
        return generatedNodeList;
    }

    private boolean isNotInitialized(int elementSize) {
        return elementSize == Integer.MAX_VALUE;
    }
}

