/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import java.util.Objects;

abstract class Cursor {
    private final String name;
    private final int index;

    public Cursor(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public boolean isMatch(ArbitraryNode<?> node) {
        boolean sameName = this.nameEquals(node.getFieldName());
        boolean sameIndex = this.indexEquals(node.getIndexOfIterable());
        return sameName && sameIndex;
    }

    public boolean indexEquals(int index) {
        return this.index == index || index == Integer.MAX_VALUE || this.index == Integer.MAX_VALUE;
    }

    public boolean nameEquals(String name) {
        return this.name.equals(name) || name.equals("*") || this.name.equals("*");
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)obj;
        boolean indexEqual = this.indexEquals(cursor.getIndex());
        boolean nameEqual = this.nameEquals(cursor.getName());
        return nameEqual && indexEqual;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

