/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.Cursor;
import com.navercorp.fixturemonkey.arbitrary.ExpIndexCursor;
import com.navercorp.fixturemonkey.arbitrary.ExpNameCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class CursorFactory {
    CursorFactory() {
    }

    public static List<Cursor> create(ArbitraryExpression.Exp exp) {
        ArrayList<Cursor> steps = new ArrayList<Cursor>();
        String expName = exp.getName();
        steps.add(new ExpNameCursor(expName));
        steps.addAll(exp.getIndex().stream().map(it -> CursorFactory.create(expName, it)).collect(Collectors.toList()));
        return steps;
    }

    public static Cursor create(String expName, ArbitraryExpression.ExpIndex expIndex) {
        return new ExpIndexCursor(expName, expIndex.getIndex());
    }

    public static List<Cursor> create(ArbitraryExpression arbitraryExpression) {
        return arbitraryExpression.getExpList().stream().filter(it -> !"HEAD_NAME".equals(it.getName())).map(CursorFactory::create).reduce(new ArrayList(), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        });
    }
}

