/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeConstraint;
import com.navercorp.fixturemonkey.arbitrary.LazyValue;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;

public class DefaultContainerArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final DefaultContainerArbitraryNodeGenerator INSTANCE = new DefaultContainerArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        int currentIndex = 0;
        int elementSize = Integer.MAX_VALUE;
        ArbitraryType<T> clazz = nowNode.getType();
        LazyValue<T> lazyValue = nowNode.getValue();
        String fieldName = nowNode.getFieldName();
        ArbitraryType elementType = clazz.getGenericArbitraryType(0);
        ArrayList generatedNodeList = new ArrayList();
        if (lazyValue != null) {
            if (lazyValue.isEmpty()) {
                nowNode.setArbitrary(Arbitraries.just(null));
                return generatedNodeList;
            }
            T value = lazyValue.get();
            if (!(value instanceof Collection || value instanceof Iterator || value instanceof Stream)) {
                throw new IllegalArgumentException("Unsupported container type is given. " + value.getClass().getName());
            }
            Iterator iterator = this.getIterator(value);
            ContainerSizeConstraint containerSizeConstraint = nowNode.getContainerSizeConstraint();
            if (containerSizeConstraint != null) {
                elementSize = containerSizeConstraint.getArbitraryElementSize();
            }
            while (currentIndex < elementSize && iterator.hasNext()) {
                Object nextObject = iterator.next();
                ArbitraryNode nextNode = ArbitraryNode.builder().type(elementType).value(nextObject).fieldName(fieldName).indexOfIterable(currentIndex).build();
                generatedNodeList.add(nextNode);
                ++currentIndex;
            }
            if (containerSizeConstraint == null) {
                nowNode.setContainerSizeConstraint(new ContainerSizeConstraint(currentIndex, currentIndex));
                return generatedNodeList;
            }
        }
        nowNode.initializeElementSize();
        if (this.isNotInitialized(elementSize)) {
            elementSize = nowNode.getContainerSizeConstraint().getArbitraryElementSize();
        }
        for (int i = currentIndex; i < elementSize; ++i) {
            ArbitraryNode nextNode = ArbitraryNode.builder().type(elementType).fieldName(fieldName).indexOfIterable(i).nullable(false).nullInject(0.0).build();
            generatedNodeList.add(nextNode);
        }
        return generatedNodeList;
    }

    private <T, U> Iterator<U> getIterator(T value) {
        if (value instanceof Collection) {
            return ((Collection)value).iterator();
        }
        if (value instanceof Stream) {
            return ((Stream)value).iterator();
        }
        return (Iterator)value;
    }

    private boolean isNotInitialized(int elementSize) {
        return elementSize == Integer.MAX_VALUE;
    }
}

