/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.NullArbitraryType;
import java.util.function.Supplier;

public class LazyValue<T> {
    private T value;
    private final Supplier<T> supplier;
    private final boolean fixed;

    public LazyValue(T value) {
        this.value = value;
        this.supplier = () -> value;
        this.fixed = true;
    }

    public LazyValue(Supplier<T> supplier, boolean fixed) {
        this.supplier = supplier;
        this.fixed = fixed;
    }

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
        this.fixed = false;
    }

    public ArbitraryType<T> getArbitraryType() {
        if (this.get() == null) {
            return NullArbitraryType.INSTANCE;
        }
        return new ArbitraryType(this.get().getClass());
    }

    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
        }
        return this.value;
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    public void clear() {
        if (!this.fixed) {
            this.value = null;
        }
    }
}

