/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.LazyValue;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.Arbitraries;

public class MapArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final MapArbitraryNodeGenerator INSTANCE = new MapArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        ArrayList generatedNodeList = new ArrayList();
        LazyValue<T> lazyValue = nowNode.getValue();
        if (lazyValue != null) {
            nowNode.setArbitrary(Arbitraries.just(lazyValue.get()));
            return generatedNodeList;
        }
        ArbitraryType<T> clazz = nowNode.getType();
        String fieldName = nowNode.getFieldName();
        ArbitraryType keyType = clazz.getGenericArbitraryType(0);
        ArbitraryType valueType = clazz.getGenericArbitraryType(1);
        nowNode.initializeElementSize();
        int elementSize = nowNode.getContainerSizeConstraint().getArbitraryElementSize();
        if (clazz.isMapEntry()) {
            elementSize = 1;
        }
        for (int i = 0; i < elementSize; ++i) {
            ArbitraryNode keyNode = ArbitraryNode.builder().type(keyType).fieldName(fieldName).indexOfIterable(i).keyOfMapStructure(true).nullInject(0.0).build();
            generatedNodeList.add(keyNode);
            ArbitraryNode valueNode = ArbitraryNode.builder().type(valueType).fieldName(fieldName).indexOfIterable(i).nullInject(0.0).build();
            generatedNodeList.add(valueNode);
        }
        return generatedNodeList;
    }
}

