/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.LazyValue;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OptionalArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final OptionalArbitraryNodeGenerator INSTANCE = new OptionalArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        ArrayList generatedNodeList = new ArrayList();
        ArbitraryType<T> arbitraryType = nowNode.getType();
        ArbitraryType elementType = arbitraryType.getGenericArbitraryType(0);
        String fieldName = nowNode.getFieldName();
        LazyValue nextLazyValue = this.getNextLazyValue(nowNode.getValue());
        if (nextLazyValue != null && nextLazyValue.isEmpty()) {
            return generatedNodeList;
        }
        ArbitraryNode nextNode = ArbitraryNode.builder().type(elementType).value(nextLazyValue).fieldName(fieldName).indexOfIterable(0).build();
        generatedNodeList.add(nextNode);
        return generatedNodeList;
    }

    private <T, U> LazyValue<U> getNextLazyValue(LazyValue<T> lazyValue) {
        if (lazyValue == null) {
            return null;
        }
        T value = lazyValue.get();
        Optional optional = (Optional)value;
        Object nextObject = optional.orElse(null);
        return new LazyValue<Object>(() -> nextObject);
    }
}

