/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpressionManipulator;
import java.util.List;

interface PriorityManipulator
extends ArbitraryExpressionManipulator,
Comparable<PriorityManipulator> {
    public Priority getPriority();

    @Override
    default public int compareTo(PriorityManipulator priorityManipulator) {
        List<ArbitraryExpression.Exp> expList = this.getArbitraryExpression().getExpList();
        List<ArbitraryExpression.Exp> oExpList = priorityManipulator.getArbitraryExpression().getExpList();
        int priorityCompare = Integer.compare(this.getPriority().ordinal(), priorityManipulator.getPriority().ordinal());
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        int compare = Integer.compare(expList.size(), oExpList.size());
        if (compare != 0) {
            return compare;
        }
        int length = expList.size();
        for (int i = 0; i < length; ++i) {
            int oExpIndexSize;
            ArbitraryExpression.Exp exp = expList.get(i);
            ArbitraryExpression.Exp oExp = oExpList.get(i);
            int expIndexSize = exp.getIndex().size();
            if (expIndexSize == (oExpIndexSize = oExp.getIndex().size())) continue;
            return Integer.compare(expIndexSize, oExpIndexSize);
        }
        return 0;
    }

    public static enum Priority {
        HIGH,
        LOW;

    }
}

