/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.customizer.ExpressionSpec;
import com.navercorp.fixturemonkey.customizer.ExpressionSpecVisitor;
import com.navercorp.fixturemonkey.customizer.IterableSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jqwik.api.Arbitraries;

final class DefaultIterableSpec
implements IterableSpec,
ExpressionSpecVisitor {
    private static final String EMPTY_FIELD = "";
    private final String iterableName;
    private final List<ExpressionSpecVisitor> next;
    private final List<IterableSpecSet> setList;
    private final List<IterableSpecPostCondition> postConditionList;
    private Integer minSize = null;
    private Integer maxSize = null;
    private boolean notNull = false;

    public DefaultIterableSpec(String iterableName) {
        this.iterableName = iterableName;
        this.next = new ArrayList<ExpressionSpecVisitor>();
        this.setList = new ArrayList<IterableSpecSet>();
        this.postConditionList = new ArrayList<IterableSpecPostCondition>();
    }

    @Override
    public IterableSpec ofMinSize(int size) {
        this.minSize = size;
        return this;
    }

    @Override
    public IterableSpec ofMaxSize(int size) {
        this.maxSize = size;
        return this;
    }

    @Override
    public IterableSpec ofSize(int size) {
        return this.ofMinSize(size).ofMaxSize(size);
    }

    @Override
    public IterableSpec ofSizeBetween(int min, int max) {
        this.maxSize = max;
        this.minSize = min;
        return this;
    }

    @Override
    public IterableSpec ofNotNull() {
        this.notNull = true;
        return this;
    }

    @Override
    public IterableSpec setElement(long fieldIndex, Object object) {
        String expression = this.getFieldExpression(this.iterableName, fieldIndex, EMPTY_FIELD);
        this.addSet(expression, object);
        return this;
    }

    @Override
    public <T> IterableSpec setElementPostCondition(long fieldIndex, Class<T> clazz, Predicate<T> postCondition) {
        return this.setElementPostCondition(fieldIndex, clazz, postCondition, Long.MAX_VALUE);
    }

    @Override
    public <T> IterableSpec setElementPostCondition(long fieldIndex, Class<T> clazz, Predicate<T> postCondition, long limit) {
        String expression = this.getFieldExpression(this.iterableName, fieldIndex, EMPTY_FIELD);
        this.addPostCondition(expression, clazz, postCondition, limit);
        return this;
    }

    @Override
    public IterableSpec listElement(long fieldIndex, Consumer<IterableSpec> spec) {
        return this.listFieldElement(fieldIndex, EMPTY_FIELD, spec);
    }

    @Override
    public IterableSpec listFieldElement(long fieldIndex, String fieldName, Consumer<IterableSpec> consumer) {
        String listName = this.getFieldExpression(this.iterableName, fieldIndex, fieldName);
        DefaultIterableSpec iterableSpec = new DefaultIterableSpec(listName);
        consumer.accept(iterableSpec);
        this.addNext(iterableSpec);
        return this;
    }

    @Override
    public IterableSpec setElementField(long fieldIndex, String fieldName, Object object) {
        String expression = this.getFieldExpression(this.iterableName, fieldIndex, fieldName);
        this.addSet(expression, object);
        return this;
    }

    @Override
    public <T> IterableSpec setElementFieldPostCondition(long fieldIndex, String fieldName, Class<T> clazz, Predicate<T> postCondition) {
        return this.setElementFieldPostCondition(fieldIndex, fieldName, clazz, postCondition, Long.MAX_VALUE);
    }

    @Override
    public <T> IterableSpec setElementFieldPostCondition(long fieldIndex, String fieldName, Class<T> clazz, Predicate<T> postCondition, long limit) {
        String expression = this.getFieldExpression(this.iterableName, fieldIndex, fieldName);
        this.addPostCondition(expression, clazz, postCondition, limit);
        return this;
    }

    @Override
    public void visit(ExpressionSpec expressionSpec) {
        this.setList.forEach(it -> expressionSpec.set(((IterableSpecSet)it).expression, ((IterableSpecSet)it).value, ((IterableSpecSet)it).limit));
        this.postConditionList.forEach(it -> expressionSpec.setPostCondition(((IterableSpecPostCondition)it).expression, ((IterableSpecPostCondition)it).clazz, ((IterableSpecPostCondition)it).postCondition, ((IterableSpecPostCondition)it).limit));
        for (ExpressionSpecVisitor nextIterableSpec : this.next) {
            nextIterableSpec.visit(expressionSpec);
        }
        if (this.notNull) {
            expressionSpec.setNotNull(this.iterableName);
        }
        if (this.minSize != null || this.maxSize != null) {
            this.minSize = this.minSize == null ? 0 : this.minSize;
            this.maxSize = this.maxSize == null ? 3 : this.maxSize;
            expressionSpec.size(this.iterableName, this.minSize, this.maxSize);
        }
    }

    @Override
    public IterableSpec any(Object object) {
        String allExpression = this.getFieldExpression(this.iterableName, "*", EMPTY_FIELD);
        long limit = this.getRandomLimit();
        this.addSet(allExpression, object, limit);
        return this;
    }

    @Override
    public IterableSpec all(Object object) {
        String allExpression = this.getFieldExpression(this.iterableName, "*", EMPTY_FIELD);
        this.addSet(allExpression, object);
        return this;
    }

    private void addNext(ExpressionSpecVisitor specVisitor) {
        this.next.add(specVisitor);
    }

    private String getFieldExpression(String collectionName, long fieldIndex, String fieldName) {
        return this.getFieldExpression(collectionName, String.valueOf(fieldIndex), fieldName);
    }

    private String getFieldExpression(String collectionName, String fieldIndex, String fieldName) {
        String expression = collectionName + "[" + fieldIndex + "]";
        if (fieldName != null && !EMPTY_FIELD.equals(fieldName)) {
            expression = expression + "." + fieldName;
        }
        return expression;
    }

    private <T> void addSet(String expression, T object) {
        this.setList.add(new IterableSpecSet<T>(expression, object));
    }

    private <T> void addSet(String expression, T object, long limit) {
        this.setList.add(new IterableSpecSet<T>(expression, object, limit));
    }

    private <T> void addPostCondition(String expression, Class<T> clazz, Predicate<T> postCondition) {
        this.postConditionList.add(new IterableSpecPostCondition<T>(expression, clazz, postCondition));
    }

    private <T> void addPostCondition(String expression, Class<T> clazz, Predicate<T> postCondition, long limit) {
        this.postConditionList.add(new IterableSpecPostCondition<T>(expression, clazz, postCondition, limit));
    }

    private long getRandomLimit() {
        return (Long)Arbitraries.longs().between((long)this.minSize.intValue(), (long)this.maxSize.intValue()).sample();
    }

    private static class IterableSpecPostCondition<T> {
        private final String expression;
        private final Class<T> clazz;
        private final Predicate<T> postCondition;
        private final long limit;

        public IterableSpecPostCondition(String expression, Class<T> clazz, Predicate<T> postCondition) {
            this.expression = expression;
            this.clazz = clazz;
            this.postCondition = postCondition;
            this.limit = Long.MAX_VALUE;
        }

        public IterableSpecPostCondition(String expression, Class<T> clazz, Predicate<T> postCondition, long limit) {
            this.expression = expression;
            this.clazz = clazz;
            this.postCondition = postCondition;
            this.limit = limit;
        }
    }

    private static class IterableSpecSet<T> {
        private final String expression;
        private final T value;
        private final long limit;

        public IterableSpecSet(String expression, T value) {
            this.expression = expression;
            this.value = value;
            this.limit = Long.MAX_VALUE;
        }

        public IterableSpecSet(String expression, T value, long limit) {
            this.expression = expression;
            this.value = value;
            this.limit = limit;
        }
    }
}

