/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.customizer.WithFixtureCustomizer;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.ArrayBuilder;
import com.navercorp.fixturemonkey.generator.CollectionBuilders;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;

public abstract class AbstractArbitraryGenerator
implements ArbitraryGenerator,
WithFixtureCustomizer {
    protected <T> Arbitrary<T> generateContainer(ArbitraryType type, List<ArbitraryNode> nodes) {
        boolean indexNotValid = nodes.stream().anyMatch(it -> it.getIndexOfIterable() == Integer.MAX_VALUE);
        if (indexNotValid) {
            throw new IllegalArgumentException("Container index should not be all index or no index.");
        }
        if (type.isArray()) {
            ArbitraryType arrayType = type.getArrayArbitraryType();
            Class<?> arrayClazz = arrayType.getType();
            return ArrayBuilder.INSTANCE.build(arrayClazz, nodes);
        }
        return CollectionBuilders.build(type.getType(), nodes);
    }

    @Override
    public final <T> Arbitrary<T> generate(ArbitraryType type, List<ArbitraryNode> nodes) {
        if (type.isContainer()) {
            return this.generateContainer(type, nodes);
        }
        return this.generateObject(type, nodes);
    }

    protected abstract <T> Arbitrary<T> generateObject(ArbitraryType var1, List<ArbitraryNode> var2);

    protected Map<String, Arbitrary> toArbitrariesByFieldName(List<ArbitraryNode> nodes, Function<ArbitraryNode, String> resolveFieldName, BiFunction<ArbitraryNode, Arbitrary, Arbitrary> resolveArbitrary) {
        HashMap<String, Arbitrary> map = new HashMap<String, Arbitrary>();
        for (ArbitraryNode node : nodes) {
            map.put(resolveFieldName.apply(node), resolveArbitrary.apply(node, node.getArbitrary()));
        }
        return Collections.unmodifiableMap(map);
    }
}

