/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.generator.IteratorBuilder;
import com.navercorp.fixturemonkey.generator.ListBuilder;
import com.navercorp.fixturemonkey.generator.MapBuilder;
import com.navercorp.fixturemonkey.generator.MapEntryBuilder;
import com.navercorp.fixturemonkey.generator.OptionalBuilder;
import com.navercorp.fixturemonkey.generator.SetBuilder;
import com.navercorp.fixturemonkey.generator.StreamBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;

final class CollectionBuilders {
    CollectionBuilders() {
    }

    public static <T> Arbitrary<T> build(Class<T> clazz, List<ArbitraryNode> nodes) {
        if (CollectionBuilders.isList(clazz)) {
            return ListBuilder.INSTANCE.build(nodes);
        }
        if (CollectionBuilders.isSet(clazz)) {
            return SetBuilder.INSTANCE.build(nodes);
        }
        if (CollectionBuilders.isStream(clazz)) {
            return StreamBuilder.INSTANCE.build(nodes);
        }
        if (CollectionBuilders.isIterator(clazz)) {
            return IteratorBuilder.INSTANCE.build(nodes);
        }
        if (CollectionBuilders.isMap(clazz)) {
            return MapBuilder.INSTANCE.build(nodes);
        }
        if (CollectionBuilders.isMapEntry(clazz)) {
            return MapEntryBuilder.INSTANCE.build(nodes);
        }
        if (CollectionBuilders.isOptional(clazz)) {
            return OptionalBuilder.INSTANCE.build(nodes);
        }
        throw new IllegalArgumentException("Not implemented collection.");
    }

    private static <T> boolean isList(Class<T> clazz) {
        return clazz.isAssignableFrom(List.class) || clazz.isAssignableFrom(Iterable.class);
    }

    private static <T> boolean isSet(Class<T> clazz) {
        return clazz.isAssignableFrom(Set.class);
    }

    private static <T> boolean isStream(Class<T> clazz) {
        return clazz.isAssignableFrom(Stream.class);
    }

    private static <T> boolean isIterator(Class<T> clazz) {
        return clazz.isAssignableFrom(Iterator.class);
    }

    private static <T> boolean isMap(Class<T> clazz) {
        return clazz.isAssignableFrom(Map.class);
    }

    private static <T> boolean isMapEntry(Class<T> clazz) {
        return clazz.isAssignableFrom(Map.Entry.class);
    }

    private static <T> boolean isOptional(Class<T> clazz) {
        return clazz.isAssignableFrom(Optional.class);
    }
}

