/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.customizer.WithFixtureCustomizer;
import com.navercorp.fixturemonkey.generator.AbstractArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.FieldArbitraries;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;

public final class ConstructorPropertiesArbitraryGenerator
extends AbstractArbitraryGenerator
implements WithFixtureCustomizer {
    public static final ConstructorPropertiesArbitraryGenerator INSTANCE = new ConstructorPropertiesArbitraryGenerator();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ArbitraryCustomizers arbitraryCustomizers;

    public ConstructorPropertiesArbitraryGenerator() {
        this(new ArbitraryCustomizers());
    }

    private ConstructorPropertiesArbitraryGenerator(ArbitraryCustomizers arbitraryCustomizers) {
        this.arbitraryCustomizers = arbitraryCustomizers;
    }

    @Override
    protected <T> Arbitrary<T> generateObject(ArbitraryType type, List<ArbitraryNode> nodes) {
        Class<?> clazz = type.getType();
        List constructors = Arrays.stream(clazz.getConstructors()).filter(c -> c.isAnnotationPresent(ConstructorProperties.class)).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException(clazz + " doesn't have constructor with 'ConstructorProperties' annotation.");
        }
        if (constructors.size() > 1) {
            throw new IllegalArgumentException(clazz + " has more then one constructor with 'ConstructorProperties' annotation.");
        }
        FieldArbitraries fieldArbitraries = new FieldArbitraries(this.toArbitrariesByFieldName(nodes, ArbitraryNode::getFieldName, (node, arbitrary) -> arbitrary));
        this.arbitraryCustomizers.customizeFields(clazz, fieldArbitraries);
        Constructor constructor = (Constructor)constructors.get(0);
        ConstructorProperties constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
        String[] providedParameterNames = constructorProperties.value();
        Parameter[] actualParameters = constructor.getParameters();
        Combinators.BuilderCombinator builderCombinator = Combinators.withBuilder(() -> new ArrayList(providedParameterNames.length));
        for (int i = 0; i < providedParameterNames.length; ++i) {
            String fieldName = providedParameterNames[i];
            Arbitrary<?> arbitrary2 = fieldArbitraries.getArbitrary(fieldName);
            if (arbitrary2 == null) {
                throw new IllegalArgumentException("No field for the corresponding constructor argument '" + fieldName + "'. Use 'ArbitraryCustomizer#customizeFields' for it.");
            }
            builderCombinator = builderCombinator.use(arbitrary2).in((list, value) -> {
                list.add(value);
                return list;
            });
        }
        return builderCombinator.build(list -> {
            Object fixture = ReflectionUtils.newInstance((Constructor)constructor, (Object[])list.toArray());
            return this.arbitraryCustomizers.customizeFixture(clazz, fixture);
        });
    }

    @Override
    public ArbitraryGenerator withFixtureCustomizers(ArbitraryCustomizers arbitraryCustomizers) {
        if (this.arbitraryCustomizers == arbitraryCustomizers) {
            return this;
        }
        return new ConstructorPropertiesArbitraryGenerator(arbitraryCustomizers);
    }
}

