/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;

final class MapBuilder {
    public static MapBuilder INSTANCE = new MapBuilder();

    MapBuilder() {
    }

    <T> Arbitrary<T> build(List<ArbitraryNode> nodes) {
        Combinators.BuilderCombinator mapBuilder = Combinators.withBuilder(MapBuilderFrame::new);
        if (nodes.isEmpty()) {
            return mapBuilder.build(MapBuilderFrame::build);
        }
        if (nodes.size() % 2 != 0) {
            throw new IllegalArgumentException("Key and Value should be existed.");
        }
        for (int i = 0; i < nodes.size() / 2; ++i) {
            int nodeIndex = i * 2;
            Arbitrary keyArbitrary = nodes.get(nodeIndex).getArbitrary();
            Arbitrary valueArbitrary = nodes.get(nodeIndex + 1).getArbitrary();
            mapBuilder = mapBuilder.use(keyArbitrary).in(MapBuilderFrame::key).use(valueArbitrary).in(MapBuilderFrame::value);
        }
        return mapBuilder.build(MapBuilderFrame::build).filter(it -> it.size() == nodes.size() / 2);
    }

    private static class MapBuilderFrame<K, V> {
        private final Map<K, V> map = new HashMap();
        private K key;

        MapBuilderFrame<K, V> key(K key) {
            this.key = key;
            return this;
        }

        MapBuilderFrame<K, V> value(V value) {
            if (this.key == null) {
                throw new IllegalArgumentException("Key can not be null when builder map.");
            }
            this.map.put(this.key, value);
            return this;
        }

        Map<K, V> build() {
            return new HashMap<K, V>(this.map);
        }
    }
}

