/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.generator.AnnotatedArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraint;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraints;
import com.navercorp.fixturemonkey.generator.AnnotationSource;
import com.navercorp.fixturemonkey.generator.RegexGenerator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.EmailArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;

public class StringAnnotatedArbitraryGenerator
implements AnnotatedArbitraryGenerator<String> {
    public static final StringAnnotatedArbitraryGenerator INSTANCE = new StringAnnotatedArbitraryGenerator();
    private static final java.util.regex.Pattern EMPTY_PATTERN = java.util.regex.Pattern.compile("");
    private static final java.util.regex.Pattern SPACE_PATTERN = java.util.regex.Pattern.compile(" ");
    private static final java.util.regex.Pattern BLANK_PATTERN = java.util.regex.Pattern.compile("[\n\t ]");
    private static final java.util.regex.Pattern CONTROL_BLOCK_PATTERN = java.util.regex.Pattern.compile("[\u0000-\u001f\u007f]");
    private static final RegexGenerator REGEX_GENERATOR = new RegexGenerator();

    @Override
    public Arbitrary<String> generate(AnnotationSource annotationSource) {
        AnnotatedGeneratorConstraint constraint = AnnotatedGeneratorConstraints.findConstraintByClass(String.class, annotationSource);
        return this.generate(constraint, annotationSource);
    }

    private Arbitrary<String> generate(AnnotatedGeneratorConstraint constraint, AnnotationSource annotationSource) {
        EmailArbitrary arbitrary;
        Optional<Pattern> pattern;
        Optional<NotBlank> notBlankAnnotations;
        BigDecimal min = constraint.getMin();
        BigDecimal max = constraint.getMax();
        boolean digits = false;
        boolean notBlank = false;
        Optional<Digits> digitsAnnotations = annotationSource.findAnnotation(Digits.class);
        if (digitsAnnotations.isPresent()) {
            digits = true;
            max = BigDecimal.valueOf(digitsAnnotations.get().integer());
        }
        if ((notBlankAnnotations = annotationSource.findAnnotation(NotBlank.class)).isPresent()) {
            notBlank = true;
            min = BigDecimal.ONE;
        }
        if ((pattern = annotationSource.findAnnotation(Pattern.class)).isPresent()) {
            Integer minValue = min != null ? Integer.valueOf(min.intValue()) : null;
            Integer maxValue = max != null ? Integer.valueOf(max.intValue()) : null;
            List<String> values = REGEX_GENERATOR.generateAll(pattern.get(), minValue, maxValue);
            if (notBlank) {
                values = values.stream().filter(this::isNotBlank).collect(Collectors.toList());
            }
            return Arbitraries.of(values);
        }
        if (annotationSource.findAnnotation(Email.class).isPresent()) {
            arbitrary = Arbitraries.emails();
            if (min != null) {
                int emailMinLength = min.intValue();
                arbitrary = arbitrary.filter(it -> it != null && it.length() >= emailMinLength);
            }
            if (max != null) {
                int emailMaxLength = max.intValue();
                arbitrary = arbitrary.filter(it -> it != null && it.length() <= emailMaxLength);
            }
        } else {
            StringArbitrary stringArbitrary = Arbitraries.strings();
            if (min != null) {
                stringArbitrary = stringArbitrary.ofMinLength(min.intValue());
            }
            if (max != null) {
                stringArbitrary = stringArbitrary.ofMaxLength(max.intValue());
            }
            stringArbitrary = digits ? stringArbitrary.numeric() : stringArbitrary.ascii();
            arbitrary = stringArbitrary;
        }
        boolean shouldReplaceBlankCharacter = notBlank;
        return arbitrary.map(v -> {
            String value = v;
            if (value != null && shouldReplaceBlankCharacter && !this.isNotBlank(value)) {
                value = EMPTY_PATTERN.matcher(value).replaceAll("a");
                value = SPACE_PATTERN.matcher(value).replaceAll("b");
                value = BLANK_PATTERN.matcher(value).replaceAll("c");
                value = CONTROL_BLOCK_PATTERN.matcher(value).replaceAll("d");
            }
            return value;
        });
    }

    private boolean isNotBlank(String value) {
        return value != null && value.trim().length() > 0;
    }
}

