/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.validator;

import com.navercorp.fixturemonkey.validator.ArbitraryValidator;
import com.navercorp.fixturemonkey.validator.DefaultArbitraryValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CompositeArbitraryValidator
implements ArbitraryValidator<Object> {
    private final Map<Class<?>, ArbitraryValidator> validators;
    private final ArbitraryValidator defaultValidator;

    public CompositeArbitraryValidator() {
        this(Collections.emptyMap());
    }

    public CompositeArbitraryValidator(Map<Class<?>, ArbitraryValidator> validators) {
        this.validators = new HashMap(validators);
        this.defaultValidator = CompositeArbitraryValidator.findDefaultValidator();
    }

    private static ArbitraryValidator findDefaultValidator() {
        return new DefaultArbitraryValidator();
    }

    @Override
    public void validate(Object arbitrary) {
        ArbitraryValidator validator = this.validators.get(arbitrary.getClass());
        if (validator != null) {
            validator.validate(arbitrary);
        }
        this.defaultValidator.validate(arbitrary);
    }
}

