/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.TypeSupports;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNullity;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeConstraint;
import com.navercorp.fixturemonkey.arbitrary.NullArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.PostArbitraryManipulator;
import com.navercorp.fixturemonkey.arbitrary.PreArbitraryManipulator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArbitraryNode<T> {
    private final List<ArbitraryNode> children;
    private final ArbitraryType<T> type;
    private final String propertyName;
    private final String metadata;
    private final int indexOfIterable;
    private final ArbitraryNodeStatus<T> status;
    private final boolean keyOfMapStructure;
    private final double nullInject;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ArbitraryNode(List<ArbitraryNode> children, ArbitraryType<T> type, String propertyName, String metadata, int indexOfIterable, ArbitraryNodeStatus<T> status, boolean keyOfMapStructure, double nullInject) {
        this.children = new ArrayList<ArbitraryNode>();
        children.forEach(this::addChildNode);
        this.type = type;
        this.propertyName = propertyName;
        this.metadata = metadata;
        this.indexOfIterable = indexOfIterable;
        this.status = status.copy();
        this.keyOfMapStructure = keyOfMapStructure;
        this.nullInject = nullInject;
    }

    public static ArbitraryNodeBuilder builder() {
        return new ArbitraryNodeBuilder();
    }

    public List<ArbitraryNode> findChildrenByCursor(ArbitraryExpression.Cursor cursor) {
        ArrayList<ArbitraryNode> foundChildren = new ArrayList<ArbitraryNode>();
        for (ArbitraryNode child : this.children) {
            ArbitraryExpression.ExpIndexCursor nodeCursor;
            if (child.isKeyOfMapStructure() || !cursor.equals(nodeCursor = new ArbitraryExpression.ExpIndexCursor(child.propertyName, child.indexOfIterable))) continue;
            child.mark();
            foundChildren.add(child);
        }
        return foundChildren;
    }

    public int getElementSize() {
        NotEmpty notEmpty;
        if (!this.type.isContainer()) {
            throw new IllegalStateException("Can not initialize element size because node is not container.");
        }
        if (this.type.isOptional()) {
            return new ContainerSizeConstraint(0, 1).getArbitraryElementSize();
        }
        if (this.getContainerSizeConstraint() != null) {
            return this.getContainerSizeConstraint().getArbitraryElementSize();
        }
        Integer min = null;
        Integer max = null;
        Size size = this.type.getAnnotation(Size.class);
        if (size != null) {
            min = size.min();
            max = size.max() != Integer.MAX_VALUE ? Integer.valueOf(size.max()) : Integer.valueOf(min + 3);
        }
        if ((notEmpty = this.type.getAnnotation(NotEmpty.class)) != null) {
            min = min != null ? Integer.valueOf(Math.max(1, min)) : Integer.valueOf(1);
        }
        return new ContainerSizeConstraint(min, max).getArbitraryElementSize();
    }

    public boolean isNotSetContainerSize() {
        return this.getContainerSizeConstraint() == null;
    }

    public void apply(PreArbitraryManipulator preArbitraryManipulator) {
        if (preArbitraryManipulator instanceof ArbitrarySetArbitrary) {
            this.setFixed(true);
            this.setArbitrary((Arbitrary)preArbitraryManipulator.getApplicableValue());
        } else if (preArbitraryManipulator instanceof AbstractArbitrarySet) {
            Class<?> toValueClazz;
            Class<?> clazz;
            Object toValue = preArbitraryManipulator.getApplicableValue();
            if (!(toValue == null || TypeSupports.isCompatibleType(clazz = this.getType().getType(), toValueClazz = toValue.getClass()) || clazz.isAssignableFrom(toValueClazz) || Arbitrary.class.isAssignableFrom(toValueClazz))) {
                this.log.warn("property \"{}\" type is \"{}\", but given set value is \"{}\".", new Object[]{this.propertyName, clazz.getSimpleName(), toValueClazz.getSimpleName()});
            }
            this.status.setValue(LazyArbitrary.lazy(() -> toValue, (boolean)true));
        } else {
            throw new IllegalArgumentException("Not Implemented PreArbitraryManipulator");
        }
    }

    public void apply(ArbitraryNullity manipulator) {
        this.setActive(manipulator.toNull() == false);
    }

    public void addChildNode(ArbitraryNode<?> child) {
        this.children.add(child);
    }

    public void setNullable(boolean nullable) {
        this.getStatus().setNullable(nullable);
    }

    public void setArbitrary(Arbitrary<T> arbitrary) {
        this.getStatus().setArbitrary(arbitrary);
    }

    public void setManipulated(boolean manipulated) {
        this.getStatus().setManipulated(manipulated);
    }

    public void setActive(boolean active) {
        this.getStatus().setActive(active);
    }

    public void setContainerSizeConstraint(ContainerSizeConstraint containerSizeConstraint) {
        this.getStatus().setContainerSizeConstraint(containerSizeConstraint);
    }

    public void setFixed(boolean fixed) {
        this.getStatus().setFixed(fixed);
    }

    public void setValue(Supplier<T> value) {
        this.getStatus().setValue(LazyArbitrary.lazy(value));
    }

    public void clearValue() {
        this.getStatus().setValue(null);
    }

    public void setReset(boolean reset) {
        this.getStatus().setReset(reset);
    }

    public void addPostArbitraryOperation(PostArbitraryManipulator postArbitraryManipulator) {
        this.status.addPostArbitraryManipulator(postArbitraryManipulator);
    }

    public Arbitrary<T> getArbitrary() {
        ArbitraryNodeStatus<T> status = this.getStatus();
        if (!status.isActive() && status.isManipulated()) {
            return Arbitraries.just(null);
        }
        return status.getArbitrary();
    }

    public boolean isNullable() {
        return ((ArbitraryNodeStatus)this.status).nullable;
    }

    public boolean isManipulated() {
        return ((ArbitraryNodeStatus)this.status).manipulated;
    }

    public boolean isActive() {
        return ((ArbitraryNodeStatus)this.status).active;
    }

    public List<ArbitraryNode> getChildren() {
        return this.children;
    }

    public ArbitraryType<T> getType() {
        if (this.type instanceof NullArbitraryType) {
            LazyArbitrary<T> value = this.getValue();
            if (value == null) {
                return this.type;
            }
            return this.getArbitraryType(value);
        }
        return this.type;
    }

    public int getIndexOfIterable() {
        return this.indexOfIterable;
    }

    @Deprecated
    public String getFieldName() {
        return this.getPropertyName();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public double getNullInject() {
        return this.nullInject;
    }

    public boolean isKeyOfMapStructure() {
        return this.keyOfMapStructure;
    }

    @Deprecated
    public ContainerSizeConstraint getContainerSizeConstraint() {
        return ((ArbitraryNodeStatus)this.status).containerSizeConstraint;
    }

    public List<PostArbitraryManipulator<T>> getPostArbitraryManipulators() {
        return ((ArbitraryNodeStatus)this.status).postArbitraryManipulators;
    }

    public boolean isFixed() {
        return this.getStatus().isFixed();
    }

    public boolean isLeafNode() {
        return (this.getChildren().isEmpty() || this.isMap()) && this.getArbitrary() != null;
    }

    @API(since="0.4.0", status=API.Status.EXPERIMENTAL)
    public boolean isMap() {
        return this.type.isMap();
    }

    public boolean isHead() {
        return this.getPropertyName().equals("$") && this.indexOfIterable == Integer.MAX_VALUE;
    }

    public LazyArbitrary<T> getValue() {
        return this.getStatus().getValue();
    }

    public boolean isReset() {
        return this.getStatus().isReset();
    }

    public boolean isDecomposedAsNull() {
        LazyArbitrary<T> value = this.getValue();
        return value != null && value.getValue() == null;
    }

    public ArbitraryNode<T> copy() {
        ArrayList<ArbitraryNode> copyChildren = new ArrayList<ArbitraryNode>();
        List<ArbitraryNode> children = this.getChildren();
        for (ArbitraryNode child : children) {
            copyChildren.add(child.copy());
        }
        return ArbitraryNode.builder().children(copyChildren).type(this.getType()).propertyName(this.getPropertyName()).metadata(this.getMetadata()).indexOfIterable(this.getIndexOfIterable()).status(this.getStatus().copy()).keyOfMapStructure(this.isKeyOfMapStructure()).nullInject(this.getNullInject()).nullable(this.isNullable()).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryNode that = (ArbitraryNode)obj;
        return this.indexOfIterable == that.indexOfIterable && this.keyOfMapStructure == that.keyOfMapStructure && Double.compare(that.nullInject, this.nullInject) == 0 && this.children.equals(that.children) && this.type.equals(that.type) && this.propertyName.equals(that.propertyName) && this.metadata.equals(that.metadata) && this.status.equals(that.status);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.type, this.propertyName, this.metadata, this.indexOfIterable, this.status, this.keyOfMapStructure, this.nullInject);
    }

    private ArbitraryNodeStatus<T> getStatus() {
        return this.status;
    }

    private void mark() {
        this.setActive(true);
        this.setManipulated(true);
        if (this.isDecomposedAsNull()) {
            this.setReset(true);
            this.setArbitrary(null);
            this.clearValue();
        }
    }

    private ArbitraryType<T> getArbitraryType(LazyArbitrary<T> lazyValue) {
        Object value = lazyValue.getValue();
        if (value == null) {
            return NullArbitraryType.INSTANCE;
        }
        return new ArbitraryType(value.getClass());
    }

    private static final class ArbitraryNodeStatus<T> {
        @Nullable
        private Arbitrary<T> arbitrary = null;
        private ContainerSizeConstraint containerSizeConstraint;
        private List<PostArbitraryManipulator<T>> postArbitraryManipulators = new ArrayList<PostArbitraryManipulator<T>>();
        private LazyArbitrary<T> value = null;
        private boolean nullable = false;
        private boolean manipulated = false;
        private boolean active = true;
        private boolean fixed = false;
        private boolean reset = false;

        private ArbitraryNodeStatus() {
        }

        public ArbitraryNodeStatus(@Nullable Arbitrary<T> arbitrary, ContainerSizeConstraint containerSizeConstraint, List<PostArbitraryManipulator<T>> postArbitraryManipulators, LazyArbitrary<T> value, boolean nullable, boolean manipulated, boolean active, boolean fixed, boolean reset) {
            this.arbitrary = arbitrary;
            this.containerSizeConstraint = containerSizeConstraint;
            this.postArbitraryManipulators = postArbitraryManipulators;
            this.value = value;
            this.nullable = nullable;
            this.manipulated = manipulated;
            this.active = active;
            this.fixed = fixed;
            this.reset = reset;
        }

        @Nullable
        public Arbitrary<T> getArbitrary() {
            return this.arbitrary;
        }

        public ContainerSizeConstraint getContainerSizeConstraint() {
            return this.containerSizeConstraint;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isManipulated() {
            return this.manipulated;
        }

        public boolean isActive() {
            return this.active;
        }

        public List<PostArbitraryManipulator<T>> getPostArbitraryManipulators() {
            return this.postArbitraryManipulators;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public LazyArbitrary<T> getValue() {
            return this.value;
        }

        public boolean isReset() {
            return this.reset;
        }

        public void setArbitrary(@Nullable Arbitrary<T> arbitrary) {
            this.arbitrary = arbitrary;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setManipulated(boolean manipulated) {
            this.manipulated = manipulated;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setReset(boolean reset) {
            this.reset = reset;
        }

        public void setContainerSizeConstraint(@Nullable ContainerSizeConstraint containerSizeConstraint) {
            this.containerSizeConstraint = containerSizeConstraint;
        }

        public void addPostArbitraryManipulator(PostArbitraryManipulator<T> postArbitraryManipulator) {
            this.postArbitraryManipulators.add(postArbitraryManipulator);
        }

        public void setPostArbitraryManipulators(List<PostArbitraryManipulator<T>> postArbitraryManipulators) {
            this.postArbitraryManipulators = postArbitraryManipulators;
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        public void setValue(LazyArbitrary<T> value) {
            this.value = value;
        }

        public ArbitraryNodeStatus<T> copy() {
            return new ArbitraryNodeStatus<T>(this.getArbitrary(), this.getContainerSizeConstraint(), this.getPostArbitraryManipulators(), this.getValue(), this.isNullable(), this.isManipulated(), this.isActive(), this.isFixed(), this.isReset());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ArbitraryNodeStatus that = (ArbitraryNodeStatus)obj;
            return this.nullable == that.nullable && this.manipulated == that.manipulated && this.active == that.active;
        }

        public int hashCode() {
            return Objects.hash(this.nullable, this.manipulated, this.active);
        }
    }

    public static final class ArbitraryNodeBuilder<T> {
        private List<ArbitraryNode> children = new ArrayList<ArbitraryNode>();
        private ArbitraryType<T> type = NullArbitraryType.INSTANCE;
        private String propertyName = "$";
        private String metadata = "";
        private int indexOfIterable = Integer.MAX_VALUE;
        private ArbitraryNodeStatus<T> status = new ArbitraryNodeStatus();
        private boolean keyOfMapStructure = false;
        private double nullInject = 0.3f;

        public ArbitraryNodeBuilder<T> children(List<ArbitraryNode> children) {
            this.children = children;
            return this;
        }

        public ArbitraryNodeBuilder<T> addChild(ArbitraryNode<?> node) {
            this.children.add(node);
            return this;
        }

        public ArbitraryNodeBuilder<T> type(ArbitraryType<T> type) {
            this.type = type;
            return this;
        }

        @Deprecated
        public ArbitraryNodeBuilder<T> fieldName(String fieldName) {
            return this.propertyName(fieldName);
        }

        public ArbitraryNodeBuilder<T> propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public ArbitraryNodeBuilder<T> metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ArbitraryNodeBuilder<T> status(ArbitraryNodeStatus<T> status) {
            this.status = status;
            return this;
        }

        public ArbitraryNodeBuilder<T> nullable(boolean nullable) {
            ((ArbitraryNodeStatus)this.status).nullable = nullable;
            return this;
        }

        public ArbitraryNodeBuilder<T> keyOfMapStructure(boolean keyOfMapStructure) {
            this.keyOfMapStructure = keyOfMapStructure;
            return this;
        }

        public ArbitraryNodeBuilder<T> indexOfIterable(int indexOfIterable) {
            this.indexOfIterable = indexOfIterable;
            return this;
        }

        public ArbitraryNodeBuilder<T> nullInject(double nullInject) {
            this.nullInject = nullInject;
            return this;
        }

        public ArbitraryNodeBuilder<T> arbitrary(Arbitrary arbitrary) {
            ((ArbitraryNodeStatus)this.status).arbitrary = arbitrary;
            return this;
        }

        public ArbitraryNodeBuilder<T> value(LazyArbitrary<T> value) {
            ((ArbitraryNodeStatus)this.status).value = value;
            return this;
        }

        public ArbitraryNodeBuilder<T> value(Supplier<T> valueSupplier) {
            ((ArbitraryNodeStatus)this.status).value = LazyArbitrary.lazy(valueSupplier);
            return this;
        }

        public ArbitraryNodeBuilder<T> value(T value) {
            ((ArbitraryNodeStatus)this.status).value = LazyArbitrary.lazy(() -> value, (boolean)true);
            return this;
        }

        public ArbitraryNodeBuilder<T> active(boolean active) {
            ((ArbitraryNodeStatus)this.status).active = active;
            return this;
        }

        public ArbitraryNode<T> build() {
            return new ArbitraryNode<T>(this.children, this.type, this.propertyName, this.metadata, this.indexOfIterable, this.status, this.keyOfMapStructure, this.nullInject);
        }
    }
}

